/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.ContainmentChangeMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Mutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationPredicates;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationTargetSelector;
import org.eclipse.emf.emfstore.modelmutator.ESAddObjectMutation;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddObjectMutation
extends ContainmentChangeMutation<ESAddObjectMutation>
implements ESAddObjectMutation {
    private EObject eObjectToAdd;

    public AddObjectMutation(ESModelMutatorUtil util) {
        super(util);
        this.addIsEmptySingleValuedReferenceOrMultivalueReferencePredicate();
    }

    protected AddObjectMutation(ESModelMutatorUtil util, MutationTargetSelector selector) {
        super(util, selector);
        this.addIsEmptySingleValuedReferenceOrMultivalueReferencePredicate();
    }

    private void addIsEmptySingleValuedReferenceOrMultivalueReferencePredicate() {
        this.getTargetContainerSelector().getOriginalFeatureValuePredicates().add(MutationPredicates.IS_NULL_OR_LIST);
    }

    @Override
    public AddObjectMutation setEObjectToAdd(EObject eObjectToAdd) {
        this.eObjectToAdd = eObjectToAdd;
        return this;
    }

    @Override
    public EObject getEObjectToAdd() {
        return this.eObjectToAdd;
    }

    @Override
    public Mutation clone() {
        AddObjectMutation mutation = new AddObjectMutation(this.getUtil(), this.getTargetContainerSelector());
        mutation.setEObjectToAdd(this.getEObjectToAdd());
        return mutation;
    }

    @Override
    public void apply() throws ESMutationException {
        this.doSelection();
        EObject eObjectToAdd = this.getOrCreateEObjectToAdd();
        this.addEObjectToTargetContainer(eObjectToAdd);
        this.getUtil().addedEObject(eObjectToAdd);
    }

    private void doSelection() throws ESMutationException {
        if (this.getEObjectToAdd() != null) {
            this.getTargetContainerSelector().getTargetFeaturePredicates().add(MutationPredicates.mayTakeEObjectAsValue(this.getEObjectToAdd()));
        }
        this.getTargetContainerSelector().doSelection();
    }

    private EObject getOrCreateEObjectToAdd() {
        if (this.getEObjectToAdd() == null) {
            this.setEObjectToAdd(this.createEObjectToAdd());
        }
        return this.getEObjectToAdd();
    }

    private EClass selectEClassToInstantiate() {
        List<EClass> eClasses = this.getAllInstatiableEClassesCompatibleWithSelectedFeature();
        int randomIndex = this.getRandom().nextInt(eClasses.size());
        return eClasses.get(randomIndex);
    }

    private List<EClass> getAllInstatiableEClassesCompatibleWithSelectedFeature() {
        EReference reference = (EReference)this.getTargetContainerSelector().getTargetFeature();
        List<EClass> eClasses = this.getUtil().getAllEContainments(reference);
        eClasses.removeAll(this.getUtil().getModelMutatorConfiguration().geteClassesToIgnore());
        for (EClass eClass : new ArrayList<EClass>(eClasses)) {
            if (ESModelMutatorUtil.canHaveInstance(eClass)) continue;
            eClasses.remove(eClass);
        }
        return eClasses;
    }

    private EObject createEObjectToAdd() {
        EClass eClassToInstantiate = this.selectEClassToInstantiate();
        EObject eObjectToAdd = EcoreUtil.create((EClass)eClassToInstantiate);
        this.getUtil().setEObjectAttributes(eObjectToAdd);
        return eObjectToAdd;
    }

    private void addEObjectToTargetContainer(EObject eObjectToAdd) {
        EObject targetObject = this.getTargetContainerSelector().getTargetObject();
        EReference targetReference = (EReference)this.getTargetContainerSelector().getTargetFeature();
        Random random = this.getRandom();
        if (targetReference.isMany()) {
            Integer insertionIndex = random.nextBoolean() ? Integer.valueOf(0) : null;
            this.getUtil().addPerCommand(targetObject, (EStructuralFeature)targetReference, eObjectToAdd, insertionIndex);
        } else {
            this.getUtil().setPerCommand(targetObject, (EStructuralFeature)targetReference, eObjectToAdd);
        }
    }
}

