/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.api;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredAdapter
extends EContentAdapter {
    private static final String E_CLASS_SUFFIX = "Impl";
    private final List<EClass> toLogClasses;
    private final List<EReference> toLogReferences;
    private final boolean attributes;
    private final boolean references;

    public FilteredAdapter(List<EClass> toLogClasses, List<EReference> toLogReferences, boolean references, boolean attributes) {
        this.toLogClasses = toLogClasses;
        this.toLogReferences = toLogReferences;
        this.references = references;
        this.attributes = attributes;
    }

    protected boolean filter(Notification notification) {
        if (!this.attributes && notification.getFeature() instanceof EAttribute) {
            return true;
        }
        if (!this.references && notification.getFeature() instanceof EReference) {
            return true;
        }
        if (this.toLogClasses == null) {
            return false;
        }
        for (EClass eClass : this.toLogClasses) {
            String string = notification.toString();
            if (!string.contains("." + eClass.getName() + E_CLASS_SUFFIX)) continue;
            if (this.toLogReferences == null) {
                return false;
            }
            for (EReference ref : this.toLogReferences) {
                if (!string.contains(ref.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public static String getEventType(int eventType) {
        switch (eventType) {
            case 1: {
                return "SET";
            }
            case 2: {
                return "UNSET";
            }
            case 3: {
                return "ADD";
            }
            case 5: {
                return "ADD_MANY";
            }
            case 4: {
                return "REMOVE";
            }
            case 6: {
                return "REMOVE_MANY";
            }
            case 7: {
                return "MOVE";
            }
            case 8: {
                return "REMOVING_ADAPTER";
            }
            case 9: {
                return "RESOLVE";
            }
        }
        return String.valueOf(eventType);
    }
}

