/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.test;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.modelmutator.api.LoggingAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLoggingAdapter
extends LoggingAdapter {
    private ProjectImpl projectImpl;

    public ProjectLoggingAdapter(ProjectImpl project, List<EClass> toLogClasses, List<EReference> toLogReferences, boolean references, boolean attributes) {
        super(toLogClasses, toLogReferences, references, attributes);
        this.projectImpl = project;
    }

    protected String format(Notification notification) {
        StringBuffer result = new StringBuffer();
        result.append("Notifier:  " + this.getModelElementId(this.projectImpl, notification.getNotifier()) + " " + notification.getNotifier());
        result.append("\n");
        result.append("Feature:   " + notification.getFeature());
        result.append("\n");
        result.append("Position:  " + notification.getPosition());
        result.append("\n");
        result.append("EventType: " + ProjectLoggingAdapter.getEventType((int)notification.getEventType()));
        result.append("\n");
        result.append("OldValue:  " + this.getModelElementId(this.projectImpl, notification.getOldValue()) + " " + notification.getOldValue());
        result.append("\n");
        result.append("NewValue:  " + this.getModelElementId(this.projectImpl, notification.getNewValue()) + " " + notification.getNewValue());
        result.append("\n");
        return result.toString();
    }

    private String getModelElementId(ProjectImpl project, Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof EObject)) {
            return null;
        }
        EObject eObject = (EObject)o;
        ModelElementId modelElementId = project.getModelElementId(eObject);
        if (modelElementId != null) {
            return modelElementId.getId();
        }
        ModelElementId deletedModelElementId = project.getDeletedModelElementId(eObject);
        return deletedModelElementId != null ? deletedModelElementId.getId() : null;
    }
}

