/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.common;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnknownEMFStoreWorkloadCommand<T> {
    private static final int DEFAULT_POLLING_INTERVAL = 200;
    private final IProgressMonitor monitor;
    private int worked;
    private double pollingInterval;

    public UnknownEMFStoreWorkloadCommand(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.pollingInterval = 200.0;
        this.worked = 0;
    }

    public T execute() throws ESException {
        double factor = 1.05;
        Future future = SingletonHolder.EXECUTOR.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return UnknownEMFStoreWorkloadCommand.this.run(UnknownEMFStoreWorkloadCommand.this.monitor);
            }
        });
        T result = null;
        boolean resultReceived = false;
        while (!resultReceived) {
            try {
                result = future.get(new Double(this.pollingInterval).intValue(), TimeUnit.MILLISECONDS);
                resultReceived = true;
            }
            catch (InterruptedException e) {
                WorkspaceUtil.logException(e.getMessage(), e);
                throw new ESException("Workload command got interrupted", (Throwable)e);
            }
            catch (ExecutionException e) {
                WorkspaceUtil.logException(e.getMessage(), e);
                if (e.getCause() instanceof ESException) {
                    throw (ESException)e.getCause();
                }
                throw new ESException(e.getCause().getMessage());
            }
            catch (TimeoutException timeoutException) {}
            this.pollingInterval *= factor;
            factor += 0.002;
            this.monitor.worked(1);
            ++this.worked;
        }
        return result;
    }

    public int getWorked() {
        return this.worked;
    }

    public abstract T run(IProgressMonitor var1) throws ESException;

    private static class SingletonHolder {
        private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();

        private SingletonHolder() {
        }
    }
}

