/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action.Messages;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ServerAdmin;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeleteOrgUnitAction
extends Action {
    private final TableViewer tableViewer;
    private final AdminBroker adminBroker;
    private final PropertiesForm form;

    protected DeleteOrgUnitAction(String title, AdminBroker adminBroker, TableViewer tableViewer, PropertiesForm form) {
        super(title);
        this.tableViewer = tableViewer;
        this.adminBroker = adminBroker;
        this.form = form;
    }

    private <T extends ACOrgUnit> List<T> toList(Iterator<T> iterator) {
        ArrayList<ACOrgUnit> ts = new ArrayList<ACOrgUnit>();
        while (iterator.hasNext()) {
            ACOrgUnit t = (ACOrgUnit)iterator.next();
            if (t == null) continue;
            ts.add(t);
        }
        return ts;
    }

    private boolean askConfirmationMessage(Shell shell, List<ACOrgUnit> orgUnits) {
        ArrayList<String> names = new ArrayList<String>();
        for (ACOrgUnit orgUnit : orgUnits) {
            names.add(orgUnit.getName());
        }
        return MessageDialog.openQuestion((Shell)shell, (String)this.confirmationMessageTitle(), (String)this.prepareQuestion(names));
    }

    private String prepareQuestion(List<String> orgUnits) {
        if (orgUnits.size() == 1) {
            return MessageFormat.format(Messages.DeleteOrgUnitAction_ConfirmationMessage_Single, orgUnits.get(0), this.orgUnitName());
        }
        StringBuilder builder = new StringBuilder(MessageFormat.format(Messages.DeleteOrgUnitAction_ConfirmationMessage_Many, this.orgUnitName()));
        builder.append(StringUtils.join(orgUnits, (String)"\n"));
        return builder.toString();
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        List<ACOrgUnit> orgUnits = this.toList(selection.iterator());
        if (!this.askConfirmationMessage(Display.getCurrent().getActiveShell(), orgUnits)) {
            return;
        }
        for (ACOrgUnit acOrgUnit : orgUnits) {
            String superUser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
            boolean isAdmin = false;
            for (Role userRole : acOrgUnit.getRoles()) {
                if (acOrgUnit.getName().compareTo(superUser) != 0 || !(userRole instanceof ServerAdmin)) continue;
                isAdmin = true;
                break;
            }
            Display display = Display.getCurrent();
            if (isAdmin) {
                MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.DeleteOrgUnitAction_IllegalDeleteionAttempt, (String)Messages.DeleteOrgUnitAction_SuperCanNotBeDeleted);
            } else {
                try {
                    this.deleteAction(acOrgUnit);
                }
                catch (AccessControlException accessControlException) {
                    MessageDialog.openWarning((Shell)display.getActiveShell(), (String)Messages.DeleteOrgUnitAction_InsufficientAccessRights, (String)(String.valueOf(Messages.DeleteOrgUnitAction_OrgUnitCanNotBeDeleted) + this.orgUnitName()));
                }
                catch (ESException ex) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                }
            }
            if (!(this.form.getCurrentInput() instanceof ACOrgUnit) || !this.form.getCurrentInput().equals(acOrgUnit)) continue;
            this.form.setInput(null);
        }
        this.tableViewer.refresh();
    }

    public AdminBroker getAdminBroker() {
        return this.adminBroker;
    }

    protected String confirmationMessageTitle() {
        return MessageFormat.format(Messages.DeleteOrgUnitAction_ConfirmationMessageTitle, this.orgUnitName());
    }

    protected abstract void deleteAction(ACOrgUnit var1) throws AccessControlException, ESException;

    protected abstract String orgUnitName();
}

