/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.fuzzy.emf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.emfstore.fuzzy.emf.ESEMFDataProvider;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.ConfigFactory;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestResult;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestRun;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class EMFRunListener
extends RunListener {
    private final TestRun testRun;
    private final ESEMFDataProvider dataProvider;
    private TestResult testResult;
    private long testStartTime;
    private final String className;

    public EMFRunListener(ESEMFDataProvider dataProvider, TestRun testRun) {
        this.dataProvider = dataProvider;
        this.testRun = testRun;
        this.className = dataProvider.getConfig().getTestClass().getName();
    }

    public void testRunFinished(Result result) {
        this.dataProvider.finish();
    }

    public void testStarted(Description description) {
        if (this.filter(description)) {
            return;
        }
        this.testResult = ConfigFactory.eINSTANCE.createTestResult();
        this.testResult.setTestName(description.getMethodName().split(" ")[0]);
        this.testStartTime = System.currentTimeMillis();
    }

    public void testFinished(Description description) {
        if (this.filter(description)) {
            return;
        }
        this.testResult.setExecutionTime(System.currentTimeMillis() - this.testStartTime);
        this.testResult.setSeedCount(this.dataProvider.getCurrentSeedCount());
        this.testRun.getResults().add((Object)this.testResult);
    }

    public void testFailure(Failure failure) {
        if (this.filter(failure.getDescription())) {
            return;
        }
        Throwable throwable = failure.getException();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            throwable.printStackTrace(new PrintWriter(sw));
            if (throwable instanceof AssertionFailedError) {
                this.testResult.setFailure(sw.toString());
            } else {
                this.testResult.setError(sw.toString());
            }
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            pw.close();
        }
    }

    private boolean filter(Description description) {
        return !description.getClassName().equals(this.className);
    }
}

