/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.scm;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.common.EClassFilter;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.VirtualNode;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ImageProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.OperationProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationId;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCMLabelProvider
extends ColumnLabelProvider {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd, HH:mm");
    private static final String ELEMENT_NOT_FOUND = Messages.SCMLabelProvider_InsufficientInformation;
    protected static final String LOCAL_REVISION = Messages.SCMLabelProvider_LocalRevision;
    private final List<OperationId> highlighted;
    private ChangePackageVisualizationHelper changePackageVisualizationHelper;
    private final Image baseRevision;
    private final Image currentRevision;
    private final Image headRevision;
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    private Project project;

    public SCMLabelProvider(Project project) {
        this.project = project;
        this.highlighted = new ArrayList<OperationId>();
        this.baseRevision = Activator.getImageDescriptor("icons/HistoryInfo_base.png").createImage();
        this.currentRevision = Activator.getImageDescriptor("icons/HistoryInfo_current.png").createImage();
        this.headRevision = Activator.getImageDescriptor("icons/HistoryInfo_head.png").createImage();
        this.init();
    }

    private void init() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        }
        if (this.adapterFactoryLabelProvider == null) {
            this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        }
    }

    public SCMLabelProvider() {
        this(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getText(Object element) {
        String ret = null;
        if (element instanceof OperationProxy) {
            OperationProxy proxy = (OperationProxy)element;
            return this.getText(proxy);
        }
        if (element instanceof HistoryInfo) {
            HistoryInfo historyInfo = (HistoryInfo)element;
            return this.getText(historyInfo);
        }
        if (element instanceof AbstractOperation && this.changePackageVisualizationHelper != null) {
            return this.changePackageVisualizationHelper.getDescription((AbstractOperation)element);
        }
        if (element instanceof ModelElementId && this.changePackageVisualizationHelper != null) {
            EObject modelElement = this.changePackageVisualizationHelper.getModelElement((ModelElementId)element);
            if (modelElement == null) return ELEMENT_NOT_FOUND;
            return this.adapterFactoryLabelProvider.getText((Object)modelElement);
        }
        if (element instanceof ChangePackage) {
            ChangePackage changePackage = (ChangePackage)element;
            return this.getText((AbstractChangePackage)changePackage);
        }
        if (element instanceof FileBasedChangePackage) {
            FileBasedChangePackage changePackage = (FileBasedChangePackage)element;
            return this.getText((AbstractChangePackage)changePackage);
        }
        if (element instanceof EObject) {
            return this.adapterFactoryLabelProvider.getText(element);
        }
        if (!(element instanceof VirtualNode)) return super.getText(element);
        return EClassFilter.INSTANCE.getFilterLabel();
    }

    private String getText(AbstractChangePackage changePackage) {
        StringBuilder builder = new StringBuilder();
        builder.append(Messages.SCMLabelProvider_ChangePackage);
        if (changePackage.getLogMessage() != null) {
            LogMessage logMessage = changePackage.getLogMessage();
            builder.append(" [");
            builder.append(logMessage.getAuthor());
            Date clientDate = logMessage.getClientDate();
            if (clientDate != null) {
                builder.append(" @ ");
                builder.append(this.dateFormat.format(clientDate));
            }
            builder.append("] ");
            builder.append(logMessage.getMessage());
        }
        return builder.toString();
    }

    protected String getText(HistoryInfo historyInfo) {
        if (historyInfo.getPrimarySpec() != null && historyInfo.getPrimarySpec().getIdentifier() == -1) {
            return LOCAL_REVISION;
        }
        String baseVersion = "";
        if (historyInfo.getPrimarySpec().getIdentifier() == ESWorkspaceProviderImpl.getProjectSpace((Project)this.project).getBaseVersion().getIdentifier()) {
            baseVersion = "*";
        }
        StringBuilder builder = new StringBuilder();
        if (!historyInfo.getTagSpecs().isEmpty()) {
            builder.append("[");
            for (TagVersionSpec versionSpec : historyInfo.getTagSpecs()) {
                builder.append(versionSpec.getName());
                builder.append(",");
            }
            builder.replace(builder.length() - 1, builder.length(), "] ");
        }
        builder.append(baseVersion);
        builder.append(Messages.SCMLabelProvider_Version);
        builder.append(historyInfo.getPrimarySpec().getIdentifier());
        LogMessage logMessage = null;
        if (historyInfo.getLogMessage() != null) {
            logMessage = historyInfo.getLogMessage();
        } else if (historyInfo.getChangePackage() != null && historyInfo.getChangePackage().getLogMessage() != null) {
            logMessage = historyInfo.getChangePackage().getLogMessage();
        }
        if (logMessage != null) {
            builder.append(" [");
            builder.append(logMessage.getAuthor());
            Date clientDate = logMessage.getClientDate();
            if (clientDate != null) {
                builder.append(" @ ");
                builder.append(this.dateFormat.format(clientDate));
            }
            builder.append("] ");
            builder.append(logMessage.getMessage());
        }
        return builder.toString();
    }

    private String getText(OperationProxy proxy) {
        if (!proxy.isLabelProviderReady()) {
            this.initProxy(proxy);
        }
        return proxy.getLabel();
    }

    private ImageData createImageFromProxy(OperationProxy proxy) {
        if (!proxy.isLabelProviderReady()) {
            this.initProxy(proxy);
        }
        ImageProxy imageProxy = proxy.getImage();
        ImageData imageData = new ImageData(imageProxy.getWidth(), imageProxy.getHeight(), imageProxy.getDepth(), this.createPaletteData(imageProxy), imageProxy.getScanlinePad(), imageProxy.getData());
        return imageData;
    }

    private PaletteData createPaletteData(ImageProxy imageProxy) {
        if (imageProxy.isDirect()) {
            return new PaletteData(imageProxy.getRedMask(), imageProxy.getGreenMask(), imageProxy.getBlueMask());
        }
        RGB[] colors = new RGB[imageProxy.getPaletteColors().length];
        int i = 0;
        while (i < imageProxy.getPaletteColors().length) {
            ImageProxy.RGB rgb = imageProxy.getPaletteColors()[i];
            colors[i] = new RGB(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
            ++i;
        }
        return new PaletteData(colors);
    }

    private void initProxy(OperationProxy proxy) {
        FileBasedChangePackage changePackage = this.getChangePackage(proxy);
        AbstractOperation operation = changePackage.get(proxy.getIndex());
        this.prepareProxy(proxy, operation);
    }

    private ImageProxy.RGB[] createColorData(RGB[] colors) {
        ImageProxy.RGB[] result = null;
        if (colors != null) {
            result = new ImageProxy.RGB[colors.length];
            int i = 0;
            while (i < colors.length) {
                result[i] = new ImageProxy.RGB(colors[i].red, colors[i].green, colors[i].blue);
                ++i;
            }
        }
        return result;
    }

    private void prepareProxy(OperationProxy proxy, AbstractOperation operation) {
        ImageData imageData = this.changePackageVisualizationHelper.getImage((ILabelProvider)this.adapterFactoryLabelProvider, operation).getImageData();
        ImageProxy imageProxy = ImageProxy.create().setWitdh(imageData.width).setHeight(imageData.height).setDepth(imageData.depth).setRedMask(imageData.palette.redMask).setGreenMask(imageData.palette.greenMask).setBlueMask(imageData.palette.blueMask).setScanlinePad(imageData.scanlinePad).setData(imageData.data);
        if (!imageData.palette.isDirect) {
            imageProxy.setPaletteColors(this.createColorData(imageData.palette.colors));
        }
        proxy.setImage(imageProxy);
        proxy.setLabel(this.changePackageVisualizationHelper.getDescription(operation));
        if (CompositeOperation.class.isInstance(operation)) {
            CompositeOperation compositeOperation = (CompositeOperation)operation;
            EList subOperations = compositeOperation.getSubOperations();
            EList proxies = proxy.getProxies();
            Iterator subOperationsIterator = subOperations.iterator();
            Iterator proxiesIterator = proxies.iterator();
            while (subOperationsIterator.hasNext()) {
                AbstractOperation op = (AbstractOperation)subOperationsIterator.next();
                OperationProxy p = (OperationProxy)proxiesIterator.next();
                this.prepareProxy(p, op);
            }
        }
    }

    private FileBasedChangePackage getChangePackage(OperationProxy proxy) {
        return (FileBasedChangePackage)ModelUtil.getParent(FileBasedChangePackage.class, (EObject)proxy);
    }

    public Color getForeground(Object element) {
        AbstractOperation operation;
        if (element instanceof AbstractOperation && this.highlighted.contains((operation = (AbstractOperation)element).getOperationId())) {
            return Display.getCurrent().getSystemColor(3);
        }
        return super.getForeground(element);
    }

    public Font getFont(Object element) {
        Font italic = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
        Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        String text = this.getText(element);
        if (text == null) {
            text = "";
        }
        if (element instanceof HistoryInfo) {
            if (text.equals(LOCAL_REVISION)) {
                return italic;
            }
            HistoryInfo historyInfo = (HistoryInfo)element;
            if (historyInfo.getPrimarySpec().getIdentifier() == ESWorkspaceProviderImpl.getProjectSpace((Project)this.project).getBaseVersion().getIdentifier()) {
                return bold;
            }
        } else if (element instanceof ModelElementId ? text.equals(ELEMENT_NOT_FOUND) : element instanceof VirtualNode) {
            return italic;
        }
        if (element instanceof EObject && ((EObject)element).eContainer() instanceof AbstractOperation) {
            AbstractOperation op = (AbstractOperation)((EObject)element).eContainer();
            if (element instanceof ModelElementId && element.equals(op.getModelElementId())) {
                return bold;
            }
            EObject modelElement = (EObject)element;
            Project project = ModelUtil.getProject((EObject)modelElement);
            if (project != null && project.getModelElementId(modelElement).equals(op.getModelElementId())) {
                return bold;
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof OperationProxy) {
            OperationProxy proxy = (OperationProxy)element;
            ImageData imageData = this.createImageFromProxy(proxy);
            Image swtImage = new Image((Device)Display.getDefault(), imageData);
            return swtImage;
        }
        if (element instanceof ModelElementId) {
            return this.adapterFactoryLabelProvider.getImage((Object)this.changePackageVisualizationHelper.getModelElement((ModelElementId)element));
        }
        if (element instanceof HistoryInfo) {
            String text = this.getText(element);
            if (text.equals(LOCAL_REVISION)) {
                return this.currentRevision;
            }
            if (text.matches("\\[.*BASE.*\\].*")) {
                return this.baseRevision;
            }
            if (text.matches("\\[.*HEAD.*\\].*")) {
                return this.headRevision;
            }
        }
        if (element instanceof CompositeOperation && ((CompositeOperation)element).getMainOperation() != null) {
            return this.changePackageVisualizationHelper.getImage((ILabelProvider)this.adapterFactoryLabelProvider, ((CompositeOperation)element).getMainOperation());
        }
        if (element instanceof AbstractOperation) {
            return this.changePackageVisualizationHelper.getImage((ILabelProvider)this.adapterFactoryLabelProvider, (AbstractOperation)element);
        }
        return this.adapterFactoryLabelProvider.getImage(element);
    }

    public void setChangePackageVisualizationHelper(ChangePackageVisualizationHelper changePackageVisualizationHelper) {
        this.changePackageVisualizationHelper = changePackageVisualizationHelper;
    }

    public ChangePackageVisualizationHelper getChangePackageVisualizationHelper() {
        return this.changePackageVisualizationHelper;
    }

    public String getToolTipText(Object element) {
        HistoryInfo historyInfo = (HistoryInfo)ModelUtil.getParent(HistoryInfo.class, (EObject)((EObject)element));
        return this.getText(historyInfo);
    }

    public List<OperationId> getHighlighted() {
        return this.highlighted;
    }

    public void dispose() {
        super.dispose();
        this.changePackageVisualizationHelper.dispose();
        this.headRevision.dispose();
        this.currentRevision.dispose();
        this.baseRevision.dispose();
        this.disposeAdapterFactories();
    }

    private void disposeAdapterFactories() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
            this.adapterFactory = null;
        }
        if (this.adapterFactoryLabelProvider != null) {
            this.adapterFactoryLabelProvider.dispose();
            this.adapterFactoryLabelProvider = null;
        }
    }

    protected Project getProject() {
        return this.project;
    }

    public void setProject(Project newProject) {
        this.project = newProject;
    }
}

