/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.util;

import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.sessionprovider.ESAbstractSessionProvider;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public class TestSessionProvider
extends ESAbstractSessionProvider {
    private Usersession session;

    private void initSession(ESServer server) {
        ESWorkspaceImpl workspace;
        Workspace internalWorkspace;
        if (server == null) {
            server = ESServer.FACTORY.createServer("localhost", 8080, "emfstore test certificate (do not use in production!)");
        }
        if (!(internalWorkspace = (Workspace)(workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace()).toInternalAPI()).getServerInfos().contains((Object)server)) {
            workspace.addServer(server);
        }
        this.session = ModelFactory.eINSTANCE.createUsersession();
        this.session.setUsername("super");
        this.session.setPassword("super");
        this.session.setSavePassword(true);
        this.session.setServerInfo((ServerInfo)((ESServerImpl)server).toInternalAPI());
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                internalWorkspace.getUsersessions().add((Object)TestSessionProvider.this.session);
            }
        });
        internalWorkspace.save();
    }

    public ESUsersession provideUsersession(ESServer serverInfo) throws ESException {
        Workspace internalWorkspace = (Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI();
        if (this.session != null && internalWorkspace.getUsersessions().contains((Object)this.session)) {
            return (ESUsersession)this.session.toAPI();
        }
        if (serverInfo != null && serverInfo.getLastUsersession() != null) {
            return serverInfo.getLastUsersession();
        }
        if (this.session == null || !internalWorkspace.getUsersessions().contains((Object)this.session)) {
            this.initSession(serverInfo);
        }
        return (ESUsersession)this.session.toAPI();
    }

    public ESUsersession login(ESUsersession usersession) throws ESException {
        this.session.logIn();
        return (ESUsersession)this.session.toAPI();
    }

    public void clearSession() {
        Workspace internalWorkspace = (Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI();
        if (this.session != null && internalWorkspace.getUsersessions().contains((Object)this.session)) {
            internalWorkspace.getUsersessions().remove((Object)this.session);
            this.session = null;
        }
    }
}

