/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.internal.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.fuzzy.emf.internal.diff.Messages;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.FuzzyUtil;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.ConfigFactory;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.DiffReport;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestConfig;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestDiff;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestResult;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffGenerator {
    private final DiffReport diffReport;
    private final Resource diffResource;

    public DiffGenerator() {
        this("../fuzzy/diff.xml");
    }

    public DiffGenerator(String diffPath) {
        this(FuzzyUtil.createResource(diffPath));
    }

    public DiffGenerator(Resource diffResource) {
        this.diffResource = diffResource;
        if (FuzzyUtil.resourceExists(diffResource)) {
            try {
                diffResource.load(null);
            }
            catch (IOException e) {
                throw new RuntimeException(String.valueOf(Messages.DiffGenerator_Could_Not_Load_Resource) + diffResource.getURI(), e);
            }
        }
        this.diffReport = DiffGenerator.getDiffReport(diffResource);
    }

    public void createDiff(TestRun firstRun, TestRun secondRun) throws IOException {
        TestConfig config = firstRun.getConfig();
        boolean containsConfig = false;
        HashMap<String, TestDiff> existingDiffs = new HashMap<String, TestDiff>();
        EList<TestDiff> diffs = this.diffReport.getDiffs();
        for (TestDiff diff : diffs) {
            TestResult result = FuzzyUtil.getValidTestResult(diff);
            existingDiffs.put(DiffGenerator.getResultIdentifier(result), diff);
            if (containsConfig || !diff.getConfig().getId().equals(config.getId())) continue;
            containsConfig = true;
            config = diff.getConfig();
        }
        if (!containsConfig) {
            this.diffResource.getContents().add((Object)config);
        }
        this.checkForDiffs((List<TestResult>)firstRun.getResults(), (List<TestResult>)secondRun.getResults(), config, (Map<String, TestDiff>)existingDiffs);
        this.checkForDiffs((List<TestResult>)secondRun.getResults(), (List<TestResult>)firstRun.getResults(), config, (Map<String, TestDiff>)existingDiffs);
        this.diffResource.getContents().add((Object)this.diffReport);
        this.diffResource.save(null);
    }

    private void checkForDiffs(List<TestResult> firstResults, List<TestResult> secondResults, TestConfig config, Map<String, TestDiff> existingDiffs) {
        EList<TestDiff> diffs = this.diffReport.getDiffs();
        for (TestResult result : new ArrayList<TestResult>(firstResults)) {
            TestResult corrResult;
            TestDiff diff = DiffGenerator.getChangedTestDiff(result, corrResult = DiffGenerator.getCorrespondingTestResult(result, secondResults));
            if (diff == null) continue;
            diff.setConfig(config);
            diffs.remove((Object)existingDiffs.get(DiffGenerator.getResultIdentifier(result)));
            diffs.add((Object)diff);
        }
    }

    private static String getResultIdentifier(TestResult result) {
        return String.valueOf(result.getTestName()) + result.getSeedCount();
    }

    private static TestDiff getChangedTestDiff(TestResult fRes, TestResult sRes) {
        boolean changed = false;
        if (fRes == null || sRes == null) {
            changed = true;
        } else if (DiffGenerator.changed(fRes.getFailure(), sRes.getFailure())) {
            changed = true;
        } else if (DiffGenerator.changed(fRes.getError(), sRes.getError())) {
            changed = true;
        } else if (fRes.getFailure() != null && sRes.getError() != null) {
            changed = true;
        } else if (fRes.getError() != null && sRes.getFailure() != null) {
            changed = true;
        }
        if (changed) {
            return DiffGenerator.createTestDiff(fRes, sRes);
        }
        return null;
    }

    private static boolean changed(Object o1, Object o2) {
        if (o1 == null && o2 != null) {
            return true;
        }
        return o1 != null && o2 == null;
    }

    private static TestDiff createTestDiff(TestResult fRes, TestResult sRes) {
        TestDiff diff = ConfigFactory.eINSTANCE.createTestDiff();
        diff.setLastUpdate(new Date(System.currentTimeMillis()));
        diff.setOldResult(fRes);
        diff.setNewResult(sRes);
        return diff;
    }

    private static TestResult getCorrespondingTestResult(TestResult result, List<TestResult> results) {
        for (TestResult res : results) {
            if (res.getSeedCount() != result.getSeedCount() || !res.getTestName().equals(result.getTestName())) continue;
            return res;
        }
        return null;
    }

    private static DiffReport getDiffReport(Resource resource) {
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof DiffReport)) continue;
            return (DiffReport)obj;
        }
        return ConfigFactory.eINSTANCE.createDiffReport();
    }
}

