/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTResourceManager {
    private static Map<RGB, Color> m_colorMap = new HashMap<RGB, Color>();
    private static Map<String, Image> m_imageMap = new HashMap<String, Image>();
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    protected static final int LAST_CORNER_KEY = 5;
    private static Map<Image, Map<Image, Image>>[] m_decoratedImageMap = new Map[5];
    private static Map<String, Font> m_fontMap = new HashMap<String, Font>();
    private static Map<Font, Font> m_fontToBoldFontMap = new HashMap<Font, Font>();
    private static Map<Integer, Cursor> m_idToCursorMap = new HashMap<Integer, Cursor>();

    public static Color getColor(int systemColorID) {
        Display display = Display.getCurrent();
        return display.getSystemColor(systemColorID);
    }

    public static Color getColor(int r, int g, int b) {
        return SWTResourceManager.getColor(new RGB(r, g, b));
    }

    public static Color getColor(RGB rgb) {
        Color color = m_colorMap.get(rgb);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rgb);
            m_colorMap.put(rgb, color);
        }
        return color;
    }

    public static void disposeColors() {
        for (Color color : m_colorMap.values()) {
            color.dispose();
        }
        m_colorMap.clear();
    }

    protected static Image getImage(InputStream stream) throws IOException {
        try {
            Display display = Display.getCurrent();
            ImageData data = new ImageData(stream);
            if (data.transparentPixel > 0) {
                Image image = new Image((Device)display, data);
                return image;
            }
            Image image = new Image((Device)display, data);
            return image;
        }
        finally {
            stream.close();
        }
    }

    public static Image getImage(String path) {
        Image image = m_imageMap.get(path);
        if (image == null) {
            try {
                image = SWTResourceManager.getImage(new FileInputStream(path));
                m_imageMap.put(path, image);
            }
            catch (Exception exception) {
                image = SWTResourceManager.getMissingImage();
                m_imageMap.put(path, image);
            }
        }
        return image;
    }

    public static Image getImage(Class<?> clazz, String path) {
        String key = String.valueOf(clazz.getName()) + '|' + path;
        Image image = m_imageMap.get(key);
        if (image == null) {
            try {
                image = SWTResourceManager.getImage(clazz.getResourceAsStream(path));
                m_imageMap.put(key, image);
            }
            catch (Exception exception) {
                image = SWTResourceManager.getMissingImage();
                m_imageMap.put(key, image);
            }
        }
        return image;
    }

    private static Image getMissingImage() {
        ImageDescriptor imageDescriptor = Activator.getImageDescriptor("icons/link_break.png");
        return imageDescriptor.createImage();
    }

    public static void disposeImages() {
        for (Image image : m_imageMap.values()) {
            image.dispose();
        }
        m_imageMap.clear();
        int i = 0;
        while (i < m_decoratedImageMap.length) {
            Map<Image, Map<Image, Image>> cornerDecoratedImageMap = m_decoratedImageMap[i];
            if (cornerDecoratedImageMap != null) {
                for (Map<Image, Image> decoratedMap : cornerDecoratedImageMap.values()) {
                    for (Image image : decoratedMap.values()) {
                        image.dispose();
                    }
                    decoratedMap.clear();
                }
                cornerDecoratedImageMap.clear();
            }
            ++i;
        }
    }

    public static Font getFont(String name, int height, int style) {
        return SWTResourceManager.getFont(name, height, style, false, false);
    }

    public static Font getFont(String name, int size, int style, boolean strikeout, boolean underline) {
        String fontName = String.valueOf(name) + '|' + size + '|' + style + '|' + strikeout + '|' + underline;
        Font font = m_fontMap.get(fontName);
        if (font == null) {
            FontData fontData = new FontData(name, size, style);
            if (strikeout || underline) {
                try {
                    Class<?> logFontClass = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                    Object logFont = FontData.class.getField("data").get(fontData);
                    if (logFont != null && logFontClass != null) {
                        if (strikeout) {
                            logFontClass.getField("lfStrikeOut").set(logFont, (byte)1);
                        }
                        if (underline) {
                            logFontClass.getField("lfUnderline").set(logFont, (byte)1);
                        }
                    }
                }
                catch (Throwable e) {
                    System.err.println("Unable to set underline or strikeout (probably on a non-Windows platform). " + e);
                }
            }
            font = new Font((Device)Display.getCurrent(), fontData);
            m_fontMap.put(fontName, font);
        }
        return font;
    }

    public static Font getBoldFont(Font baseFont) {
        Font font = m_fontToBoldFontMap.get(baseFont);
        if (font == null) {
            FontData[] fontDatas = baseFont.getFontData();
            FontData data = fontDatas[0];
            font = new Font((Device)Display.getCurrent(), data.getName(), data.getHeight(), 1);
            m_fontToBoldFontMap.put(baseFont, font);
        }
        return font;
    }

    public static void disposeFonts() {
        for (Font font : m_fontMap.values()) {
            font.dispose();
        }
        m_fontMap.clear();
        for (Font font : m_fontToBoldFontMap.values()) {
            font.dispose();
        }
        m_fontToBoldFontMap.clear();
    }

    public static Cursor getCursor(int id) {
        Integer key = id;
        Cursor cursor = m_idToCursorMap.get(key);
        if (cursor == null) {
            cursor = new Cursor((Device)Display.getDefault(), id);
            m_idToCursorMap.put(key, cursor);
        }
        return cursor;
    }

    public static void disposeCursors() {
        for (Cursor cursor : m_idToCursorMap.values()) {
            cursor.dispose();
        }
        m_idToCursorMap.clear();
    }

    public static void dispose() {
        SWTResourceManager.disposeColors();
        SWTResourceManager.disposeImages();
        SWTResourceManager.disposeFonts();
        SWTResourceManager.disposeCursors();
    }
}

