/*******************************************************************************
 * Copyright (c) 2008-2011 Chair for Applied Software Engineering,
 * Technische Universitaet Muenchen.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 ******************************************************************************/
package org.eclipse.emf.emfstore.internal.server.model.versioning;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc --> The <b>Factory</b> for the model. It provides a
 * create method for each non-abstract class of the model. <!-- end-user-doc -->
 *
 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningPackage
 * @generated
 */
public interface VersioningFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 *
	 * @generated
	 */
	VersioningFactory eINSTANCE = org.eclipse.emf.emfstore.internal.server.model.versioning.impl.VersioningFactoryImpl
		.init();

	/**
	 * Returns a new object of class '<em>Tag Version Spec</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Tag Version Spec</em>'.
	 * @generated
	 */
	TagVersionSpec createTagVersionSpec();

	/**
	 * Returns a new object of class '<em>Date Version Spec</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Date Version Spec</em>'.
	 * @generated
	 */
	DateVersionSpec createDateVersionSpec();

	/**
	 * Returns a new object of class '<em>Primary Version Spec</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Primary Version Spec</em>'.
	 * @generated
	 */
	PrimaryVersionSpec createPrimaryVersionSpec();

	/**
	 * Returns a new object of class '<em>Log Message</em>'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Log Message</em>'.
	 * @generated
	 */
	LogMessage createLogMessage();

	/**
	 * Returns a new object of class '<em>Change Package</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Change Package</em>'.
	 * @generated
	 */
	ChangePackage createChangePackage();

	/**
	 * Returns a new object of class '<em>History Info</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>History Info</em>'.
	 * @generated
	 */
	HistoryInfo createHistoryInfo();

	/**
	 * Returns a new object of class '<em>Range Query</em>'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Range Query</em>'.
	 * @generated
	 */
	@SuppressWarnings("rawtypes")
	RangeQuery createRangeQuery();

	/**
	 * Returns a new object of class '<em>Path Query</em>'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Path Query</em>'.
	 * @generated
	 */
	PathQuery createPathQuery();

	/**
	 * Returns a new object of class '<em>Model Element Query</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Model Element Query</em>'.
	 * @generated
	 */
	ModelElementQuery createModelElementQuery();

	/**
	 * Returns a new object of class '<em>Version</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Version</em>'.
	 * @generated
	 */
	Version createVersion();

	/**
	 * Returns a new object of class '<em>Head Version Spec</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Head Version Spec</em>'.
	 * @generated
	 */
	HeadVersionSpec createHeadVersionSpec();

	/**
	 * Returns a new object of class '<em>Version Property</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Version Property</em>'.
	 * @generated
	 */
	VersionProperty createVersionProperty();

	/**
	 * Returns a new object of class '<em>Branch Version Spec</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Branch Version Spec</em>'.
	 * @generated
	 */
	BranchVersionSpec createBranchVersionSpec();

	/**
	 * Returns a new object of class '<em>Branch Info</em>'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Branch Info</em>'.
	 * @generated
	 */
	BranchInfo createBranchInfo();

	/**
	 * Returns a new object of class '<em>Ancestor Version Spec</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Ancestor Version Spec</em>'.
	 * @generated
	 */
	AncestorVersionSpec createAncestorVersionSpec();

	/**
	 * Returns a new object of class '<em>Paged Update Version Spec</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Paged Update Version Spec</em>'.
	 * @generated
	 */
	PagedUpdateVersionSpec createPagedUpdateVersionSpec();

	/**
	 * Returns a new object of class '<em>File Based Change Package</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>File Based Change Package</em>'.
	 * @generated
	 */
	FileBasedChangePackage createFileBasedChangePackage();

	/**
	 * Returns a new object of class '<em>Operation Proxy</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Operation Proxy</em>'.
	 * @generated
	 */
	OperationProxy createOperationProxy();

	/**
	 * Returns a new object of class '<em>Change Package Envelope</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Change Package Envelope</em>'.
	 * @generated
	 */
	ChangePackageEnvelope createChangePackageEnvelope();

	/**
	 * Returns a new object of class '<em>Change Package Proxy</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Change Package Proxy</em>'.
	 * @generated
	 */
	ChangePackageProxy createChangePackageProxy();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the package supported by this factory.
	 * @generated
	 */
	VersioningPackage getVersioningPackage();

} // VersioningFactory