/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.fuzzy.emf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.emfstore.fuzzy.emf.ESTestConfig;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.Messages;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.api.ESTestConfigImpl;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestConfig;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestDiff;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestResult;
import org.junit.runners.model.TestClass;

public final class FuzzyUtil {
    public static final String FUZZY_FOLDER = "fuzzy/";
    public static final String ROOT_FOLDER = "../fuzzy/";
    public static final String RUN_FOLDER = "testruns/";
    public static final String FILE_SUFFIX = ".xml";
    public static final String TEST_CONFIG_FILE = "fuzzyConfig.fuzzy";
    public static final String TEST_CONFIG_PATH = "fuzzy/fuzzyConfig.fuzzy";
    public static final String DIFF_FILE = "../fuzzy/diff.xml";
    public static final String PROPERTIES_FILE = "fuzzy/fuzzy.properties";
    public static final String PROP_PRE = "fuzzy";
    private static final AdapterFactoryEditingDomain EDITING_DOMAIN = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack());
    private static Properties properties;

    private FuzzyUtil() {
    }

    public static ESTestConfig getTestConfig(Resource resource, TestClass testClass) {
        for (EObject object : resource.getContents()) {
            TestConfig config;
            Class<?> clazz;
            if (!(object instanceof TestConfig) || !(clazz = (config = (TestConfig)object).getTestClass()).getName().equals(testClass.getJavaClass().getName())) continue;
            return new ESTestConfigImpl(config);
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.FuzzyUtil_NoTestConfigFound, testClass.getName(), resource.getURI()));
    }

    public static boolean containsConfig(Resource resource, TestConfig config) {
        for (EObject obj : resource.getContents()) {
            TestConfig c;
            if (!(obj instanceof TestConfig) || !(c = (TestConfig)obj).getId().equals(config.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean resourceExists(Resource resource) {
        return resource.getResourceSet().getURIConverter().exists(resource.getURI(), null);
    }

    public static Resource createResource(String fileNameURI) {
        return EDITING_DOMAIN.createResource(fileNameURI);
    }

    public static TestResult getValidTestResult(TestDiff diff) {
        TestResult result = diff.getOldResult();
        if (result != null) {
            return result;
        }
        result = diff.getNewResult();
        if (result != null) {
            return result;
        }
        throw new RuntimeException(Messages.FuzzyUtil_WrontTestDiffConfiguration);
    }

    public static String getProperty(String key, String defaultValue) {
        FuzzyUtil.initProperties();
        return properties.getProperty(PROP_PRE + key, defaultValue);
    }

    private static void initProperties() {
        if (properties != null) {
            return;
        }
        File file = new File(PROPERTIES_FILE);
        properties = new Properties();
        if (file.exists()) {
            try {
                FileInputStream fs = new FileInputStream(file);
                properties.load(fs);
                fs.close();
            }
            catch (IOException e) {
                throw new RuntimeException(MessageFormat.format(Messages.FuzzyUtil_LoadPropertiesFailed, file.getAbsolutePath()), e);
            }
        }
    }
}

