/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview;

import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.SCMLabelProvider;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;

public class HistorySCMLabelProvider
extends SCMLabelProvider {
    protected String getText(HistoryInfo historyInfo) {
        if (historyInfo.getPrimarySpec() != null && historyInfo.getPrimarySpec().getIdentifier() == -1) {
            return "Local revision";
        }
        String baseVersion = "";
        if (historyInfo.getPrimarySpec().getIdentifier() == ESWorkspaceProviderImpl.getProjectSpace((Project)this.getProject()).getBaseVersion().getIdentifier()) {
            baseVersion = "*";
        }
        StringBuilder builder = new StringBuilder();
        if (!historyInfo.getTagSpecs().isEmpty()) {
            builder.append("[");
            for (TagVersionSpec versionSpec : historyInfo.getTagSpecs()) {
                builder.append(versionSpec.getName());
                builder.append(",");
            }
            builder.replace(builder.length() - 1, builder.length(), "] ");
        }
        builder.append(baseVersion);
        builder.append("Version ");
        builder.append(historyInfo.getPrimarySpec().getIdentifier());
        return builder.toString();
    }

    public String getToolTipText(Object element) {
        return this.getText(element);
    }
}

