/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.model.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.common.ESSafeRunnable;
import org.eclipse.emf.emfstore.common.ESSafeRunner;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.NotifiableIdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.impl.EObjectChangeObserverNotificationCommand;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.EObjectChangeNotifier;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotifiableIdEObjectCollectionImpl
extends IdEObjectCollectionImpl
implements NotifiableIdEObjectCollection {
    private boolean isNotifiying;
    private List<IdEObjectCollectionChangeObserver> observers;
    private Set<IdEObjectCollectionChangeObserver> exceptionThrowingObservers;
    private Set<IdEObjectCollectionChangeObserver> observersToRemove;
    private Set<IdEObjectCollectionChangeObserver> undetachableObservers;
    private Set<IdEObjectCollectionChangeObserver> observersToAttach;
    private EObjectChangeNotifier changeNotifier;

    protected NotifiableIdEObjectCollectionImpl() {
        this.initObservers();
    }

    public NotifiableIdEObjectCollectionImpl(XMIResource xmiResource) throws IOException {
        super(xmiResource);
        this.initObservers();
        this.changeNotifier = new EObjectChangeNotifier(this, (Notifier)xmiResource);
    }

    private void initObservers() {
        this.observers = new ArrayList<IdEObjectCollectionChangeObserver>();
        this.observersToRemove = new LinkedHashSet<IdEObjectCollectionChangeObserver>();
        this.exceptionThrowingObservers = new LinkedHashSet<IdEObjectCollectionChangeObserver>();
        this.undetachableObservers = new LinkedHashSet<IdEObjectCollectionChangeObserver>();
        this.observersToAttach = new LinkedHashSet<IdEObjectCollectionChangeObserver>();
    }

    @Override
    public void modelElementAdded(final IdEObjectCollection collection, final EObject eObject) {
        this.addToResource(eObject);
        this.addModelElementAndChildrenToCache(eObject);
        EObjectChangeObserverNotificationCommand command = new EObjectChangeObserverNotificationCommand(){

            public void run(IdEObjectCollectionChangeObserver projectChangeObserver) {
                projectChangeObserver.modelElementAdded(collection, eObject);
            }
        };
        this.notifyIdEObjectCollectionChangeObservers(command);
    }

    private void addToResource(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource != null && resource != this.eResource()) {
            EcoreUtil.remove((EObject)eObject);
        }
    }

    public abstract void addCutElement(EObject var1);

    protected synchronized void notifyIdEObjectCollectionChangeObservers(final EObjectChangeObserverNotificationCommand command) {
        this.isNotifiying = true;
        for (final IdEObjectCollectionChangeObserver changeObserver : this.observers) {
            ESSafeRunnable code = new ESSafeRunnable(){

                public void run() {
                    command.run(changeObserver);
                }

                public void handleException(Throwable exception) {
                    if (NotifiableIdEObjectCollectionImpl.this.exceptionThrowingObservers.contains(changeObserver)) {
                        if (!NotifiableIdEObjectCollectionImpl.this.undetachableObservers.contains(changeObserver)) {
                            NotifiableIdEObjectCollectionImpl.this.observersToRemove.add(changeObserver);
                            ModelUtil.logException("EObject Change Observer threw an exception again, it has been detached, UI may not update now: " + changeObserver.getClass().getName(), exception);
                        } else {
                            ModelUtil.logException("EObject Change Observer threw an exception again, but it will not be detached." + changeObserver.getClass().getName(), exception);
                        }
                    } else {
                        NotifiableIdEObjectCollectionImpl.this.exceptionThrowingObservers.add(changeObserver);
                        ModelUtil.logWarning("EObject Change Observer threw an exception: " + changeObserver.getClass().getName(), exception);
                    }
                }
            };
            ESSafeRunner.run((ESSafeRunnable)code);
        }
        this.isNotifiying = false;
        for (IdEObjectCollectionChangeObserver observer : this.observersToRemove) {
            this.removeIdEObjectCollectionChangeObserver(observer);
        }
        for (IdEObjectCollectionChangeObserver observer : this.observersToAttach) {
            this.addIdEObjectCollectionChangeObserver(observer);
        }
        this.observersToRemove.clear();
    }

    @Override
    public void initMapping() {
        if (this.isCacheInitialized()) {
            return;
        }
        super.initMapping();
        if (this.changeNotifier == null) {
            this.changeNotifier = new EObjectChangeNotifier(this, (Notifier)this);
        }
    }

    @Override
    public void initMapping(Map<EObject, String> eObjectToIdMap, Map<String, EObject> idToEObjectMap) {
        super.initMapping(eObjectToIdMap, idToEObjectMap);
        if (this.changeNotifier == null) {
            this.changeNotifier = new EObjectChangeNotifier(this, (Notifier)this);
        }
    }

    @Override
    public void notify(final Notification notification, final IdEObjectCollection project, final EObject modelElement) {
        ResourceImpl resourceImpl;
        EObjectChangeObserverNotificationCommand command = new EObjectChangeObserverNotificationCommand(){

            public void run(IdEObjectCollectionChangeObserver projectChangeObserver) {
                projectChangeObserver.notify(notification, project, modelElement);
            }
        };
        Resource resource = modelElement.eResource();
        if (resource != null && resource instanceof ResourceImpl && (resourceImpl = (ResourceImpl)resource).isLoading()) {
            return;
        }
        this.notifyIdEObjectCollectionChangeObservers(command);
    }

    @Override
    public synchronized void addIdEObjectCollectionChangeObserver(IdEObjectCollectionChangeObserver eObjectChangeObserver) {
        this.initMapping();
        if (this.isNotifiying) {
            this.observersToAttach.add(eObjectChangeObserver);
            return;
        }
        this.observers.add(eObjectChangeObserver);
    }

    @Override
    public synchronized void removeIdEObjectCollectionChangeObserver(IdEObjectCollectionChangeObserver projectChangeObserver) {
        if (this.isNotifiying) {
            this.observersToRemove.add(projectChangeObserver);
            return;
        }
        this.observers.remove(projectChangeObserver);
        this.exceptionThrowingObservers.remove(projectChangeObserver);
        this.undetachableObservers.remove(projectChangeObserver);
    }

    public void setUndetachable(IdEObjectCollectionChangeObserver observer) {
        this.undetachableObservers.add(observer);
    }

    @Override
    public void modelElementRemoved(final IdEObjectCollection projectImpl, final EObject modelElement) {
        this.removeModelElementAndChildrenFromCache(modelElement);
        EObjectChangeObserverNotificationCommand command = new EObjectChangeObserverNotificationCommand(){

            public void run(IdEObjectCollectionChangeObserver projectChangeObserver) {
                projectChangeObserver.modelElementRemoved(projectImpl, modelElement);
            }
        };
        this.notifyIdEObjectCollectionChangeObservers(command);
    }

    @Override
    public <T extends IdEObjectCollection> T copy() {
        if (this.changeNotifier != null) {
            this.changeNotifier.disableNotifications(true);
        }
        Object result = super.copy();
        if (this.changeNotifier != null) {
            this.changeNotifier.disableNotifications(false);
        }
        return result;
    }

    @Override
    public void collectionDeleted(IdEObjectCollection collection) {
    }

    @Override
    public EObjectChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }
}

