/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;

public abstract class ESAbstractServerURIConverter
extends ExtensibleURIConverterImpl {
    public URI normalize(URI uri) {
        if (uri.scheme() != null && uri.scheme().equals("emfstore") && uri.authority().equals("serverspaces")) {
            if (uri.segment(1).equals("serverspace")) {
                return this.normalizeServerSpaceURI(uri.segment(0));
            }
            if (uri.segment(1).equals("dynamic-models")) {
                return this.normalizeDynamicModelsURI(uri.segment(0), uri.segment(2));
            }
            if (uri.segment(1).equals("projects")) {
                return this.normalizeProjects(uri);
            }
        }
        return super.normalize(uri);
    }

    private URI normalizeProjects(URI uri) {
        if (uri.segment(3).equals("projecthistory")) {
            return this.normalizeProjectHistoryURI(uri.segment(0), uri.segment(2));
        }
        if (uri.segment(3).equals("versions")) {
            return this.normalizeVersionURI(uri.segment(0), uri.segment(2), Integer.valueOf(uri.segment(4)));
        }
        if (uri.segment(3).equals("changepackages")) {
            return this.normalizeChangePackageURI(uri.segment(0), uri.segment(2), Integer.valueOf(uri.segment(4)));
        }
        if (uri.segment(3).equals("projectstates")) {
            return this.normalizeProjectStateURI(uri.segment(0), uri.segment(2), Integer.valueOf(uri.segment(4)));
        }
        return super.normalize(uri);
    }

    protected abstract URI normalizeServerSpaceURI(String var1);

    protected URI normalizeDynamicModelsURI(String profile, String ecoreName) {
        return URI.createFileURI((String)(String.valueOf(ServerConfiguration.getServerHome()) + "dynamic-models" + "/" + ecoreName));
    }

    protected abstract URI normalizeProjectHistoryURI(String var1, String var2);

    protected abstract URI normalizeVersionURI(String var1, String var2, int var3);

    protected abstract URI normalizeChangePackageURI(String var1, String var2, int var3);

    protected abstract URI normalizeProjectStateURI(String var1, String var2, int var3);
}

