/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.internal.server.connection.ServerKeyStoreManager;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ClientVersionOutOfDateException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ServerKeyStoreException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;

public abstract class AbstractAuthenticationControl
implements AuthenticationControl {
    private final String superuser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
    private final String superuserpw = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser.password", "super");

    public AuthenticationInformation logIn(ACUser resolvedUser, String username, String password, ClientVersionInfo clientVersionInfo) throws AccessControlException {
        this.checkClientVersion(clientVersionInfo);
        password = this.preparePassword(password);
        if (this.verifySuperUser(username, password) || this.verifyPassword(resolvedUser, username, password)) {
            return this.createAuthenticationInfo();
        }
        throw new AccessControlException();
    }

    protected AuthenticationInformation createAuthenticationInfo() {
        AuthenticationInformation authenticationInformation = ModelFactory.eINSTANCE.createAuthenticationInformation();
        authenticationInformation.setSessionId(ModelFactory.eINSTANCE.createSessionId());
        return authenticationInformation;
    }

    protected String preparePassword(String password) throws ServerKeyStoreException {
        return ServerKeyStoreManager.getInstance().decrypt(password);
    }

    protected boolean verifySuperUser(String username, String password) {
        return username.equals(this.superuser) && password.equals(this.superuserpw);
    }

    public void logout(SessionId sessionId) throws AccessControlException {
    }

    protected abstract boolean verifyPassword(ACUser var1, String var2, String var3) throws AccessControlException;

    protected void checkClientVersion(ClientVersionInfo clientVersionInfo) throws ClientVersionOutOfDateException {
        if (clientVersionInfo == null) {
            throw new ClientVersionOutOfDateException("No client version recieved.");
        }
        String[] versions = ServerConfiguration.getSplittedProperty("emfstore.acceptedversions");
        if (versions == null) {
            ModelUtil.logWarning((String)"No server versions supplied", (Throwable)new ClientVersionOutOfDateException("No server versions supplied"));
            return;
        }
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.equals(clientVersionInfo.getVersion()) || str.equals("any")) {
                return;
            }
            ++n2;
        }
        StringBuffer version = new StringBuffer();
        String[] stringArray2 = versions;
        int n3 = versions.length;
        n = 0;
        while (n < n3) {
            String str = stringArray2[n];
            if (versions.length == 1) {
                version.append(String.valueOf(str) + ". ");
            } else {
                version.append(String.valueOf(str) + ", ");
            }
            ++n;
        }
        version.replace(version.length() - 2, version.length(), ".");
        throw new ClientVersionOutOfDateException("Client version: " + clientVersionInfo.getVersion() + " - Accepted versions: " + version);
    }
}

