/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.core.ast;

import java.util.ArrayList;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.core.ast.OutlineNode;
import org.eclipse.gymnast.runtime.core.ast.PropertySourceNodeImpl;
import org.eclipse.gymnast.runtime.core.ast.TokenInfo;

public abstract class OutlineNodeImpl
extends PropertySourceNodeImpl {
    public OutlineNodeImpl() {
    }

    public OutlineNodeImpl(TokenInfo tokenInfo) {
        super(tokenInfo);
    }

    public OutlineNode getOutlineParent() {
        ASTNode parent = this.getParent();
        while (parent != null) {
            if (parent instanceof OutlineNode) {
                return (OutlineNode)((Object)parent);
            }
            parent = parent.getParent();
        }
        return null;
    }

    public boolean hasOutlineChildren() {
        return this.getOutlineChildren().length > 0;
    }

    public OutlineNode[] getOutlineChildren() {
        ArrayList<ASTNode> list = new ArrayList<ASTNode>();
        int i = 0;
        while (i < this.getChildCount()) {
            ASTNode child = this.getChild(i);
            if (child instanceof OutlineNode) {
                list.add(child);
            }
            ++i;
        }
        return list.toArray(new OutlineNode[list.size()]);
    }

    public String getOutlineText() {
        String text = this.getText();
        return text == null ? "" : text;
    }

    public int getOutlineOffset() {
        return this.getRangeStart();
    }

    public int getOutlineLength() {
        return this.getRangeLength();
    }
}

