/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.ui.outline;

import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.core.outline.OutlineNode;
import org.eclipse.gymnast.runtime.ui.editor.LDTEditor;
import org.eclipse.gymnast.runtime.ui.outline.LDTOutlineConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class LDTContentOutlinePage
extends ContentOutlinePage {
    private LDTEditor _editor;
    private IEditorInput _input;
    private boolean _isDisposed;

    public LDTContentOutlinePage(LDTEditor editor) {
        this._editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer treeViewer = this.getTreeViewer();
        LDTOutlineConfiguration outlineConfiguration = this._editor.getOutlineConfiguration();
        treeViewer.setContentProvider((IContentProvider)outlineConfiguration.createOutlineContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)outlineConfiguration.createOutlineLabelProvide());
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this._input != null) {
            treeViewer.setInput((Object)this._input);
        }
    }

    public void dispose() {
        this._isDisposed = true;
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this._editor.resetHighlightRange();
        } else {
            try {
                IStructuredSelection ssel = (IStructuredSelection)selection;
                OutlineNode node = (OutlineNode)ssel.getFirstElement();
                this.highlight(node.getASTNode(), true);
            }
            catch (Exception exception) {
                this._editor.resetHighlightRange();
            }
        }
    }

    private void highlight(ASTNode node, boolean moveCursor) {
        if (node != null) {
            int offset = node.getRangeStart();
            int length = node.getRangeLength();
            if (offset == -1) {
                this._editor.resetHighlightRange();
            } else {
                this._editor.setHighlightRange(offset, length, moveCursor);
            }
        }
    }

    public void select(ASTNode node) {
        if (node != null) {
            TreeViewer viewer = this.getTreeViewer();
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            viewer.setSelection((ISelection)new StructuredSelection((Object)node));
            this.highlight(node, false);
            viewer.reveal((Object)node);
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void setInput(IEditorInput input) {
        this._input = input;
        this.update();
    }

    public void update() {
        if (this._isDisposed) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LDTContentOutlinePage.this.updateHelper();
            }
        });
    }

    private void updateHelper() {
        Control control;
        if (this._isDisposed) {
            return;
        }
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (control = treeViewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            treeViewer.setInput((Object)this._input);
            treeViewer.expandAll();
            control.setRedraw(true);
        }
    }
}

