/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.ui.editor;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.core.outline.IOutlineBuilder;
import org.eclipse.gymnast.runtime.core.outline.OutlineNode;
import org.eclipse.gymnast.runtime.core.parser.IParser;
import org.eclipse.gymnast.runtime.ui.editor.LDTSourceViewerConfiguration;
import org.eclipse.gymnast.runtime.ui.outline.LDTContentOutlinePage;
import org.eclipse.gymnast.runtime.ui.outline.LDTOutlineConfiguration;
import org.eclipse.gymnast.runtime.ui.views.parsetree.IParseTreeChangedListener;
import org.eclipse.gymnast.runtime.ui.views.parsetree.IParseTreeViewInput;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class LDTEditor
extends TextEditor
implements IParseTreeViewInput {
    private LDTSourceViewerConfiguration _sourceViewerConfiguration;
    private LDTOutlineConfiguration _outlineConfiguration;
    private ASTNode _parseRoot;
    private LDTContentOutlinePage _outlinePage;
    private SelectionChangedListener _selectionChangedListener;
    private TextInputListener _textInputListener;
    private ArrayList<IParseTreeChangedListener> _parseTreeChangedListeners = new ArrayList();

    protected void initializeEditor() {
        super.initializeEditor();
        this._sourceViewerConfiguration = this.createSourceViewerConfiguration();
        this.setSourceViewerConfiguration(this._sourceViewerConfiguration);
        this._outlineConfiguration = this.createOutlineConfiguration();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this._selectionChangedListener = this.createSelectionChangedListener();
        this._textInputListener = this.createTextInputListener();
    }

    public void dispose() {
        super.dispose();
        if (this._textInputListener != null) {
            this._textInputListener.dispose();
            this._textInputListener = null;
        }
        if (this._selectionChangedListener != null) {
            this._selectionChangedListener.dispose();
            this._selectionChangedListener = null;
        }
    }

    protected abstract LDTSourceViewerConfiguration createSourceViewerConfiguration();

    protected LDTOutlineConfiguration createOutlineConfiguration() {
        return new LDTOutlineConfiguration(this);
    }

    public LDTOutlineConfiguration getOutlineConfiguration() {
        return this._outlineConfiguration;
    }

    public IParser getParser() {
        return this._sourceViewerConfiguration.getParser();
    }

    public IOutlineBuilder getOutlineBuilder() {
        return this._outlineConfiguration.getOutlineBuilder();
    }

    public IFile getFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            return input.getFile();
        }
        return null;
    }

    void setParseRoot(ASTNode parseRoot) {
        this._parseRoot = parseRoot;
        int i = 0;
        while (i < this._parseTreeChangedListeners.size()) {
            IParseTreeChangedListener listener = this._parseTreeChangedListeners.get(i);
            listener.parseTreeChanged(new ASTNode[]{this._parseRoot});
            ++i;
        }
        if (this._outlinePage != null) {
            this._outlinePage.update();
        }
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this._outlinePage == null && this.getOutlineBuilder() != null) {
                this._outlinePage = this._outlineConfiguration.createContentOutlinePage();
                IEditorInput input = this.getEditorInput();
                if (input != null) {
                    this._outlinePage.setInput(input);
                }
            }
            return this._outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public OutlineNode[] getOutlineElements() {
        IOutlineBuilder outlineBuilder = this.getOutlineBuilder();
        OutlineNode[] elements = null;
        if (outlineBuilder != null) {
            try {
                elements = outlineBuilder.buildOutline(this._parseRoot);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return elements;
    }

    @Override
    public void addParseTreeChangedListener(IParseTreeChangedListener listener) {
        this._parseTreeChangedListeners.add(listener);
    }

    @Override
    public void removeParseTreeChangedListener(IParseTreeChangedListener listener) {
        this._parseTreeChangedListeners.remove(listener);
    }

    @Override
    public ASTNode getParseRoot() {
        return this._parseRoot;
    }

    @Override
    public void selectNode(ASTNode node) {
        if (node != null) {
            this.selectAndReveal(node.getRangeStart(), node.getRangeLength());
        }
    }

    @Override
    public ASTNode getNodeAtCursor() {
        int cursorPos = this.getSourceViewer().getTextWidget().getCaretOffset();
        if (this._parseRoot != null) {
            return this._parseRoot.getNodeAt(cursorPos, 0);
        }
        return null;
    }

    protected SelectionChangedListener createSelectionChangedListener() {
        return null;
    }

    protected TextInputListener createTextInputListener() {
        return null;
    }

    protected class SelectionChangedListener
    implements ISelectionChangedListener {
        private ISelectionProvider _selectionProvider;

        public SelectionChangedListener(ISelectionProvider selectionProvider) {
            this._selectionProvider = selectionProvider;
            this._selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void dispose() {
            this._selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
        }
    }

    protected class TextInputListener
    implements ITextInputListener {
        private ISourceViewer _sourceViewer;

        public TextInputListener(ISourceViewer sourceViewer) {
            this._sourceViewer = sourceViewer;
            this._sourceViewer.addTextInputListener((ITextInputListener)this);
        }

        public void dispose() {
            this._sourceViewer.removeTextInputListener((ITextInputListener)this);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        }
    }
}

