/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.jumper;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.debug.gdbjtag.DebugUtils;
import ilg.gnumcueclipse.debug.gdbjtag.jumper.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.jumper.DynamicVariableResolver;
import ilg.gnumcueclipse.debug.gdbjtag.jumper.preferences.DefaultPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;

public class Configuration {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getGdbServerCommand(ILaunchConfiguration configuration, String executable) {
        DefaultPreferences fDefaultPreferences;
        block3: {
            try {
                if (executable != null) return Configuration.resolveAll(executable, configuration);
                fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
                if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart())) break block3;
                return null;
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
                return null;
            }
        }
        executable = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.gdbServerExecutable", fDefaultPreferences.getGdbServerExecutable());
        return Configuration.resolveAll(executable, configuration);
    }

    public static String getGdbServerCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbServerCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    private static String executeCommand(String command) {
        StringBuffer output = new StringBuffer();
        try {
            Process p = Runtime.getRuntime().exec("whoami");
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                output.append(String.valueOf(line) + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    public static String findExecutableOnPath(String name) {
        String path = String.valueOf(System.getenv("PATH")) + File.pathSeparator + "/usr/local/bin";
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dirname = stringArray[n2];
            File file = new File(dirname, name);
            if (file.isFile() && file.canExecute()) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        throw new AssertionError((Object)"Jumper Virtual Lab was not installed. Please head to https://docs.jumper.io for installation instructions.");
    }

    public static String[] getGdbServerCommandLineArray(ILaunchConfiguration configuration) {
        File file;
        String executable;
        ArrayList<String> lst;
        block12: {
            block11: {
                lst = new ArrayList<String>();
                try {
                    DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
                    if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart())) break block11;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log((Throwable)e);
                    return null;
                }
            }
            executable = Configuration.getGdbServerCommand(configuration, null);
            if (executable != null && executable.length() != 0) break block12;
            return null;
        }
        if (EclipseUtils.isWindows()) {
            executable = String.valueOf(executable) + ".exe";
        }
        String pathToExe = Configuration.findExecutableOnPath(executable);
        lst.add(pathToExe);
        lst.add("run");
        IPath exePath = LaunchUtils.verifyProgramPath((ILaunchConfiguration)configuration, null);
        if (exePath != null) {
            lst.add("--fw=" + exePath);
        }
        String boardName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.gdbServerBoardName", "").trim();
        if (!(boardName = DebugUtils.resolveAll((String)boardName, (Map)configuration.getAttributes())).isEmpty()) {
            lst.add("--platform=" + boardName);
        }
        String deviceName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.gdbServerDeviceName", "").trim();
        if (!(deviceName = DebugUtils.resolveAll((String)deviceName, (Map)configuration.getAttributes())).isEmpty()) {
            file = new File(deviceName);
            if (file.exists() && file.getParent() != null) {
                lst.add("--directory=" + file.getParent());
            }
        } else {
            file = new File(exePath.toString());
            lst.add("--directory=" + file.getParent());
        }
        lst.add("--gdb");
        String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.gdbServerOther", "--uart").trim();
        other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
        if (!other.isEmpty()) {
            lst.addAll(StringUtils.splitCommandLineOptions((String)other));
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbServerCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbServerCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String getGdbServerOtherConfig(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.gdbServerOther", "--uart").trim();
    }

    public static String getJumperBoardName(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.gdbServerBoardName", "").trim();
    }

    public static String getJumperDeviceName(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.gdbServerDeviceName", "").trim();
    }

    public static String getGdbClientCommand(ILaunchConfiguration configuration, String executable) {
        try {
            if (executable == null) {
                String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
                executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            }
            executable = Configuration.resolveAll(executable, configuration);
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
        return executable;
    }

    public static String[] getGdbClientCommandLineArray(ILaunchConfiguration configuration) {
        ArrayList<String> lst = new ArrayList<String>();
        String executable = Configuration.getGdbClientCommand(configuration, null);
        if (executable == null || executable.length() == 0) {
            return null;
        }
        lst.add(executable);
        lst.add("--interpreter=mi2");
        lst.add("--nx");
        try {
            DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
            String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.gdbClientOtherOptions", fDefaultPreferences.getGdbClientOtherOptions()).trim();
            other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
            if (other.length() > 0) {
                lst.addAll(StringUtils.splitCommandLineOptions((String)other));
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbClientCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbClientCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String getGdbClientCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbClientCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String resolveAll(String str, ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String value = str;
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        if (value.indexOf("${") >= 0 && (project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)configuration)) != null) {
            value = DynamicVariableResolver.resolveAll(value, project);
        }
        if (value.indexOf("${") >= 0) {
            value = DebugUtils.resolveAll((String)value, (Map)configuration.getAttributes());
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                value = DebugUtils.resolveAll((String)value, (ICConfigurationDescription)buildConfig);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.resolveAll(\"" + str + "\") = \"" + value + "\"");
        }
        return value;
    }

    public static boolean getDoStartGdbServer(ILaunchConfiguration config) throws CoreException {
        DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart());
    }

    public static boolean getDoAddServerConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jumper.doGdbServerAllocateConsole", true);
    }
}

