/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.SignatureSubpacketsFunction;

public abstract class AbstractOpenPGPKeySignatureGenerator {
    protected SignatureSubpacketsFunction defaultAeadAlgorithmPreferences = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(39);
            pGPSignatureSubpacketGenerator.setPreferredAEADCiphersuites(PreferredAEADCiphersuites.builder(false).addCombination(9, 2).addCombination(8, 2).addCombination(7, 2));
            return pGPSignatureSubpacketGenerator;
        }
    };
    protected SignatureSubpacketsFunction defaultSymmetricKeyPreferences = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(11);
            pGPSignatureSubpacketGenerator.setPreferredSymmetricAlgorithms(false, new int[]{9, 8, 7});
            return pGPSignatureSubpacketGenerator;
        }
    };
    protected SignatureSubpacketsFunction defaultHashAlgorithmPreferences = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(21);
            pGPSignatureSubpacketGenerator.setPreferredHashAlgorithms(false, new int[]{14, 12, 10, 9, 8});
            return pGPSignatureSubpacketGenerator;
        }
    };
    protected SignatureSubpacketsFunction defaultCompressionAlgorithmPreferences = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(22);
            pGPSignatureSubpacketGenerator.setPreferredCompressionAlgorithms(false, new int[]{0, 1, 2, 3});
            return pGPSignatureSubpacketGenerator;
        }
    };
    protected SignatureSubpacketsFunction defaultFeatures = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(30);
            pGPSignatureSubpacketGenerator.setFeature(false, (byte)9);
            return pGPSignatureSubpacketGenerator;
        }
    };
    protected SignatureSubpacketsFunction signingSubkeySubpackets = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(27);
            pGPSignatureSubpacketGenerator.setKeyFlags(true, 2);
            return pGPSignatureSubpacketGenerator;
        }
    };
    protected SignatureSubpacketsFunction encryptionSubkeySubpackets = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(27);
            pGPSignatureSubpacketGenerator.setKeyFlags(true, 12);
            return pGPSignatureSubpacketGenerator;
        }
    };
    protected SignatureSubpacketsFunction directKeySignatureSubpackets = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator = AbstractOpenPGPKeySignatureGenerator.this.defaultFeatures.apply(pGPSignatureSubpacketGenerator);
            pGPSignatureSubpacketGenerator = AbstractOpenPGPKeySignatureGenerator.this.defaultHashAlgorithmPreferences.apply(pGPSignatureSubpacketGenerator);
            pGPSignatureSubpacketGenerator = AbstractOpenPGPKeySignatureGenerator.this.defaultCompressionAlgorithmPreferences.apply(pGPSignatureSubpacketGenerator);
            pGPSignatureSubpacketGenerator = AbstractOpenPGPKeySignatureGenerator.this.defaultSymmetricKeyPreferences.apply(pGPSignatureSubpacketGenerator);
            pGPSignatureSubpacketGenerator = AbstractOpenPGPKeySignatureGenerator.this.defaultAeadAlgorithmPreferences.apply(pGPSignatureSubpacketGenerator);
            return pGPSignatureSubpacketGenerator;
        }
    };

    public void setDefaultAeadAlgorithmPreferences(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.defaultAeadAlgorithmPreferences = signatureSubpacketsFunction;
    }

    public void setDefaultSymmetricKeyPreferences(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.defaultSymmetricKeyPreferences = signatureSubpacketsFunction;
    }

    public void setDefaultHashAlgorithmPreferences(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.defaultHashAlgorithmPreferences = signatureSubpacketsFunction;
    }

    public void setDefaultCompressionAlgorithmPreferences(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.defaultCompressionAlgorithmPreferences = signatureSubpacketsFunction;
    }

    public void setDirectKeySignatureSubpackets(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.directKeySignatureSubpackets = signatureSubpacketsFunction;
    }

    public void setDefaultFeatures(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.defaultFeatures = signatureSubpacketsFunction;
    }

    public void setSigningSubkeySubpackets(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.signingSubkeySubpackets = signatureSubpacketsFunction;
    }

    public void setEncryptionSubkeySubpackets(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.encryptionSubkeySubpackets = signatureSubpacketsFunction;
    }
}

