/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.session;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.JavaHelper;
import org.eclipse.egf.common.helper.ObjectHolder;
import org.eclipse.egf.core.EGFCoreDebug;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectBundleSession {
    private static final String EGF_TARGET_BUNDLE_PRIORITY = "egf.target.bundle.priority";
    public static String PROJECT_BUNDLE_SESSION = "org.eclipse.egf.core.project.bundle.session";
    private BundleContext context;
    private Map<String, Bundle> projectBundles = new HashMap<String, Bundle>();
    private List<String> uninstalled = new UniqueEList();
    private Boolean runtimeBundlePriority;

    public static String getLocation(IPluginModelBase model) throws CoreException {
        if (model == null) {
            return null;
        }
        IResource resource = model.getUnderlyingResource();
        if (resource == null) {
            return null;
        }
        String location = null;
        try {
            location = "reference:" + URLDecoder.decode(resource.getProject().getLocationURI().toURL().toExternalForm(), System.getProperty("file.encoding"));
        }
        catch (Throwable t) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_URLFailure, (Object)resource.getProject().getName()), t));
        }
        return location;
    }

    public ProjectBundleSession(BundleContext context) {
        Assert.isNotNull((Object)context);
        this.context = context;
    }

    private void installWorkspaceModels(List<Bundle> bundles, List<IPluginModelBase> workspaceModels) throws CoreException {
        if (bundles == null || workspaceModels == null || workspaceModels.size() == 0) {
            return;
        }
        for (IPluginModelBase workspaceModel : workspaceModels) {
            if (this.projectBundles.get(ProjectBundleSession.getLocation(workspaceModel)) != null) continue;
            String location = ProjectBundleSession.getLocation(workspaceModel);
            Bundle bundle = this.installBundle(location);
            IProject project = workspaceModel.getUnderlyingResource().getProject();
            this.addOutputFoldersToBundleClasspath(project, bundle);
            bundles.add(bundle);
            if (EGFCoreDebug.isDebugBundleSession() && this.uninstalled.size() == 0 && this.projectBundles.size() == 0) {
                EGFCorePlugin.getDefault().logInfo("Start ProjectBundleSession...");
            }
            this.projectBundles.put(location, bundle);
        }
    }

    private Bundle installBundle(IPluginModelBase model) throws CoreException {
        if (ProjectBundleSession.getLocation(model) == null) {
            return null;
        }
        String bundleId = BundleHelper.getBundleId((IPluginModelBase)model);
        if (bundleId == null) {
            return null;
        }
        List<IPluginModelBase> workspaceModels = this.getWorkspaceModelDependencies(model);
        UniqueEList registryContributors = new UniqueEList();
        for (IPluginModelBase workspaceModel : workspaceModels) {
            if (workspaceModel.getPluginBase().getExtensions() == null || workspaceModel.getPluginBase().getExtensions().length <= 0) continue;
            String workspaceBundleId = BundleHelper.getBundleId((IPluginModelBase)workspaceModel);
            String location = ProjectBundleSession.getLocation(workspaceModel);
            if (workspaceBundleId == null || this.projectBundles.containsKey(location)) continue;
            registryContributors.add(workspaceBundleId);
        }
        ObjectHolder loadCompleted = new ObjectHolder();
        IRegistryEventListener registryListener = null;
        if (!registryContributors.isEmpty()) {
            registryListener = new IRegistryEventListener((List)registryContributors, loadCompleted){
                private final /* synthetic */ List val$registryContributors;
                private final /* synthetic */ ObjectHolder val$loadCompleted;
                {
                    this.val$registryContributors = list;
                    this.val$loadCompleted = objectHolder;
                }

                public void removed(IExtension[] extensions) {
                }

                public void added(IExtension[] extensions) {
                    IExtension[] iExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        this.val$registryContributors.remove(extension.getContributor().getName());
                        if (this.val$registryContributors.isEmpty()) {
                            this.val$loadCompleted.object = Boolean.TRUE;
                        }
                        ++n2;
                    }
                }

                public void added(IExtensionPoint[] extensionPoints) {
                }

                public void removed(IExtensionPoint[] extensionPoints) {
                }
            };
            RegistryFactory.getRegistry().addListener(registryListener);
        }
        UniqueEList bundles = new UniqueEList();
        this.internalInstallBundle((List<Bundle>)bundles, workspaceModels);
        if (registryListener != null) {
            int timeout;
            block14: {
                timeout = 20;
                try {
                    try {
                        while (loadCompleted.object == null && timeout-- > 0) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        RegistryFactory.getRegistry().removeListener(registryListener);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    RegistryFactory.getRegistry().removeListener(registryListener);
                    throw throwable;
                }
                RegistryFactory.getRegistry().removeListener(registryListener);
            }
            if (timeout < 0) {
                EGFCorePlugin.getDefault().logWarning("Some bundles (related to " + bundleId + ") may not be fully loaded.");
            }
        }
        if (EGFCoreDebug.isDebugBundleSession()) {
            for (Bundle bundle : bundles) {
                EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Workspace Bundle ''{0}'' is started.", (Object)bundle.getSymbolicName()));
            }
        }
        return Platform.getBundle((String)bundleId);
    }

    private void internalInstallBundle(List<Bundle> bundles, List<IPluginModelBase> workspaceModels) throws CoreException {
        this.uninstallRuntimeBundle(workspaceModels);
        ArrayList<Bundle> workspaceBundles = new ArrayList<Bundle>(bundles);
        this.installWorkspaceModels(bundles, workspaceModels);
        if (!bundles.isEmpty()) {
            this.refreshPackages(bundles.toArray(new Bundle[bundles.size()]));
        }
        for (Bundle bundle : bundles) {
            try {
                if (bundle.getState() != 32) {
                    bundle.start(1);
                    continue;
                }
                workspaceBundles.remove(bundle);
            }
            catch (Throwable t) {
                throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_StartFailure, (Object)bundle), t));
            }
        }
    }

    private void uninstallRuntimeBundle(List<IPluginModelBase> workspaceModels) throws CoreException {
        if (workspaceModels == null || workspaceModels.isEmpty()) {
            return;
        }
        UniqueEList models = new UniqueEList();
        UniqueEList bundles = new UniqueEList();
        for (IPluginModelBase workspaceModel : workspaceModels) {
            Bundle bundle;
            String bundleId;
            if (this.projectBundles.get(ProjectBundleSession.getLocation(workspaceModel)) != null || (bundleId = BundleHelper.getBundleId((IPluginModelBase)workspaceModel)) == null || (bundle = Platform.getBundle((String)bundleId)) == null) continue;
            if (bundle.getState() == 2 || bundle.getState() == 4 || bundle.getState() == 8 || bundle.getState() == 16 || bundle.getState() == 32) {
                this.uninstallBundle(bundle);
            }
            models.add(workspaceModel);
            this.uninstalled.add(bundle.getLocation());
            bundles.add(bundle);
            if (!EGFCoreDebug.isDebugBundleSession() || this.uninstalled.size() != 0) continue;
            EGFCorePlugin.getDefault().logInfo("Start ProjectBundleSession...");
        }
        if (!models.isEmpty()) {
            this.refreshPackages(bundles.toArray(new Bundle[bundles.size()]));
            if (EGFCoreDebug.isDebugBundleSession()) {
                for (IPluginModelBase model : models) {
                    EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Runtime Bundle ''{0}'' is uninstalled.", (Object)BundleHelper.getBundleId((IPluginModelBase)model)));
                }
            }
        }
    }

    private List<IPluginModelBase> getWorkspaceModelDependencies(IPluginModelBase base) throws CoreException {
        IPluginModelBase workspaceModel;
        int n;
        int n2;
        IPluginModelBase[] iPluginModelBaseArray;
        UniqueEList dependencies = new UniqueEList();
        dependencies.add(base);
        BundleDescription description = base.getBundleDescription();
        if (description == null) {
            return dependencies;
        }
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n3 = bundleSpecificationArray.length;
        int n4 = 0;
        while (n4 < n3) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n4];
            iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            n2 = iPluginModelBaseArray.length;
            n = 0;
            while (n < n2) {
                workspaceModel = iPluginModelBaseArray[n];
                if (requiredBundle.isSatisfiedBy((BaseDescription)workspaceModel.getBundleDescription())) {
                    dependencies.addAll(this.getWorkspaceModelDependencies(workspaceModel));
                    break;
                }
                ++n;
            }
            ++n4;
        }
        bundleSpecificationArray = description.getImportPackages();
        n3 = bundleSpecificationArray.length;
        n4 = 0;
        while (n4 < n3) {
            BundleSpecification importPackage = bundleSpecificationArray[n4];
            iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            n2 = iPluginModelBaseArray.length;
            n = 0;
            while (n < n2) {
                workspaceModel = iPluginModelBaseArray[n];
                ExportPackageDescription[] exportPackageDescriptionArray = workspaceModel.getBundleDescription().getExportPackages();
                int n5 = exportPackageDescriptionArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    ExportPackageDescription export = exportPackageDescriptionArray[n6];
                    if (importPackage.isSatisfiedBy((BaseDescription)export)) {
                        dependencies.addAll(this.getWorkspaceModelDependencies(workspaceModel));
                        break;
                    }
                    ++n6;
                }
                ++n;
            }
            ++n4;
        }
        if (this.isRuntimeBundlePriority()) {
            for (IPluginModelBase innerBase : new ArrayList(dependencies)) {
                if (Platform.getBundle((String)innerBase.getBundleDescription().getSymbolicName()) == null) continue;
                dependencies.remove(innerBase);
            }
        }
        return dependencies;
    }

    private Bundle installBundle(String location) throws CoreException {
        Bundle bundle = null;
        try {
            bundle = this.context.installBundle(location);
        }
        catch (Throwable t) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_InstallationFailure, (Object)location), t));
        }
        if (bundle == null) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_InstallationFailure, (Object)location), null));
        }
        int state = bundle.getState();
        if (state != 2) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_IllegalBundleState, (Object)bundle, (Object)state), null));
        }
        return bundle;
    }

    private void addOutputFoldersToBundleClasspath(IProject project, Bundle bundle) throws CoreException {
        List outputFolders = JavaHelper.getStringOutputFolders((IJavaProject)JavaCore.create((IProject)project));
        BaseData bundleData = (BaseData)((AbstractBundle)bundle).getBundleData();
        StringBuilder classpath = new StringBuilder();
        if (outputFolders.size() == 0) {
            classpath.append(".");
        } else {
            Iterator it = outputFolders.iterator();
            while (it.hasNext()) {
                if (classpath.length() > 0) {
                    classpath.append(",");
                }
                classpath.append((String)it.next());
            }
        }
        bundleData.setClassPathString(classpath.toString());
    }

    public Bundle getBundle(String id) throws CoreException {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        IPluginModelBase model = PluginRegistry.findModel((String)id.trim());
        if (model == null) {
            return null;
        }
        if (model.getUnderlyingResource() == null || this.isRuntimeBundlePriority()) {
            return Platform.getBundle((String)id.trim());
        }
        String location = ProjectBundleSession.getLocation(model);
        if (location == null) {
            return null;
        }
        Bundle bundle = this.projectBundles.get(location);
        if (bundle == null) {
            return this.installBundle(model);
        }
        return bundle;
    }

    public Bundle getBundle(IProject project) throws CoreException {
        Bundle bundle;
        String id;
        if (project == null) {
            return null;
        }
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model == null) {
            return null;
        }
        if (this.isRuntimeBundlePriority() && (id = BundleHelper.getBundleId((IPluginModelBase)model)) != null && (bundle = Platform.getBundle((String)id)) != null) {
            return bundle;
        }
        String location = ProjectBundleSession.getLocation(model);
        if (location == null) {
            return null;
        }
        bundle = this.projectBundles.get(location);
        if (bundle == null) {
            bundle = this.installBundle(model);
        }
        return bundle;
    }

    private void refreshPackages(Bundle[] bundles) throws CoreException {
        ServiceReference packageAdminReference = this.context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)this.context.getService(packageAdminReference);
        }
        if (packageAdmin == null) {
            return;
        }
        final ObjectHolder thrown = new ObjectHolder();
        final ObjectHolder loadCompleted = new ObjectHolder();
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4 || event.getType() == 2) {
                    if (event.getType() == 2) {
                        thrown.object = event.getThrowable();
                    }
                    loadCompleted.object = Boolean.TRUE;
                } else if (event.getType() == 16 && event.getThrowable() != null) {
                    EGFCorePlugin.getDefault().logWarning(event.getThrowable());
                }
            }
        };
        this.context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        int timeout = 20;
        try {
            while (loadCompleted.object == null && timeout-- > 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (timeout < 0) {
            EGFCorePlugin.getDefault().logWarning("Some bundles may not be fully loaded.");
        }
        this.context.removeFrameworkListener(listener);
        this.context.ungetService(packageAdminReference);
        if (thrown.object != null) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, EGFCoreMessages.ProjectBundleSession_PackageRefreshFailure, (Throwable)thrown.object));
        }
    }

    public void dispose() throws CoreException {
        UniqueEList uninstalledBundles = new UniqueEList(this.uninstalled.size());
        if (!this.projectBundles.isEmpty() || !this.uninstalled.isEmpty()) {
            if (!(!EGFCoreDebug.isDebugBundleSession() || this.projectBundles.isEmpty() && this.uninstalled.isEmpty())) {
                EGFCorePlugin.getDefault().logInfo("Dispose ProjectBundleSession...");
            }
            if (!this.projectBundles.isEmpty()) {
                for (Bundle bundle : this.projectBundles.values()) {
                    this.uninstallBundle(bundle);
                }
                this.refreshPackages(this.projectBundles.values().toArray(new Bundle[this.projectBundles.size()]));
                if (EGFCoreDebug.isDebugBundleSession() && !this.projectBundles.isEmpty()) {
                    for (Bundle bundle : this.projectBundles.values()) {
                        EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Workspace Bundle ''{0}'' is uninstalled.", (Object)bundle.getSymbolicName()), 1);
                    }
                }
            }
            if (!this.uninstalled.isEmpty()) {
                for (String location : this.uninstalled) {
                    uninstalledBundles.add(this.installBundle(location));
                }
                this.refreshPackages(uninstalledBundles.toArray(new Bundle[uninstalledBundles.size()]));
                if (EGFCoreDebug.isDebugBundleSession() && !this.uninstalled.isEmpty()) {
                    for (Bundle bundle : uninstalledBundles) {
                        EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Runtime Bundle ''{0}'' is installed.", (Object)bundle.getSymbolicName()), 1);
                    }
                }
            }
        }
        this.projectBundles.clear();
        this.uninstalled.clear();
    }

    private void uninstallBundle(Bundle bundle) throws CoreException {
        try {
            bundle.uninstall();
        }
        catch (BundleException be) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_UninstallationFailure, (Object)bundle.getSymbolicName()), be));
        }
    }

    private boolean isRuntimeBundlePriority() {
        if (this.runtimeBundlePriority == null) {
            String property = System.getProperty(EGF_TARGET_BUNDLE_PRIORITY);
            this.runtimeBundlePriority = Boolean.TRUE.toString().equals(property);
        }
        return this.runtimeBundlePriority;
    }
}

