/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class SelectNextPatchSetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent aEvent) {
        IEditorInput activeEditorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)aEvent);
        if (activeEditorInput instanceof GerritMultipleInput) {
            String commandName = aEvent.getCommand().getId();
            boolean isLeftSide = commandName.contains("selectLeftPatchSet");
            GerritMultipleInput input = (GerritMultipleInput)activeEditorInput;
            ArrayList revisions = new ArrayList(input.getChangeInfo().getRevisions().values());
            revisions.sort((o2, o1) -> o1.get_number() - o2.get_number());
            LinkedHashMap<String, String> patchNumber = new LinkedHashMap<String, String>();
            ListIterator iter = revisions.listIterator();
            while (iter.hasNext()) {
                RevisionInfo element = (RevisionInfo)iter.next();
                patchNumber.put(Integer.toString(element.get_number()), element.getId());
            }
            patchNumber.put("WORKSPACE", "WORKSPACE");
            patchNumber.put("BASE", "BASE");
            Iterator<Map.Entry<String, String>> itr = patchNumber.entrySet().iterator();
            Iterator<Map.Entry<String, String>> first = patchNumber.entrySet().iterator();
            this.selectNext(isLeftSide, input, itr, first);
        }
        return Status.OK_STATUS;
    }

    private void selectNext(boolean isLeftSide, GerritMultipleInput input, Iterator<Map.Entry<String, String>> itr, Iterator<Map.Entry<String, String>> first) {
        boolean found = false;
        while (itr.hasNext()) {
            Map.Entry<String, String> entry = itr.next();
            if (isLeftSide && entry.getValue().compareTo(input.getLeftSide()) == 0) {
                entry = this.selectFirstOrNext(itr, first);
                input.switchInputs(entry.getValue(), null);
                found = true;
            }
            if (!isLeftSide && entry.getValue().compareTo(input.getRightSide()) == 0) {
                entry = this.selectFirstOrNext(itr, first);
                input.switchInputs(null, entry.getValue());
                found = true;
            }
            if (found) break;
        }
    }

    private Map.Entry<String, String> selectFirstOrNext(Iterator<Map.Entry<String, String>> itr, Iterator<Map.Entry<String, String>> first) {
        Map.Entry<String, String> entry = itr.hasNext() ? itr.next() : first.next();
        return entry;
    }
}

