/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.fx.ide.model.Visibility;
import org.eclipse.fx.ide.model.internal.FXCtrlClass;
import org.eclipse.fx.ide.model.internal.utils.Util;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class FXCtrlEventMethod
implements IFXCtrlEventMethod {
    private FXCtrlClass clazz;
    private IMethod method;
    private String erasedFQNType;

    public FXCtrlEventMethod(FXCtrlClass clazz, IMethod method, String erasedFQNType) {
        this.clazz = clazz;
        this.method = method;
        this.erasedFQNType = erasedFQNType;
    }

    @Override
    public IJavaElement getJavaElement() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.method.getElementName();
    }

    @Override
    public boolean hasArgument() {
        return this.erasedFQNType != null;
    }

    @Override
    public IType getArgumentType() {
        try {
            return this.clazz.getJavaProject().findType(this.erasedFQNType);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Visibility getVisibility() {
        try {
            int flags = this.method.getFlags();
            if (Flags.isPublic((int)flags)) {
                return Visibility.PUBLIC;
            }
            if (Flags.isPackageDefault((int)flags)) {
                return Visibility.PACKAGE;
            }
            if (Flags.isProtected((int)flags)) {
                return Visibility.PROTECTED;
            }
            return Visibility.PRIVATE;
        }
        catch (JavaModelException e) {
            FXPlugin.getLogger().log(1, "Unable to retrieve visibility for method '" + String.valueOf(this.method) + "'", (Throwable)e);
            return Visibility.PRIVATE;
        }
    }

    public static boolean isEventMethod(IJavaProject jp, String erasedFQNType) throws JavaModelException {
        String checkType = erasedFQNType;
        do {
            if ("javafx.event.Event".equals(checkType)) {
                return true;
            }
            IType t = jp.findType(checkType);
            if (t == null) {
                return false;
            }
            checkType = t.getSuperclassName();
            if (checkType == null) continue;
            checkType = Util.getFQNType(t, checkType);
        } while (checkType != null);
        return false;
    }
}

