/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeSignature;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;

public class BinaryObjectTypeSignature
extends BinaryTypeSignature {
    BinaryObjectTypeSignature(String internalName) {
        super(internalName);
    }

    @Override
    protected void toIdentifier(StringBuilder builder, int identifierFixup) {
        BinaryTypeSignature componentType = this.getArrayComponentType();
        if (componentType != this) {
            componentType.toIdentifier(builder, identifierFixup);
            int dim = this.getArrayDimensions();
            for (int i = 0; i < dim; ++i) {
                builder.append("[]");
            }
        } else {
            int max = this.offset + this.length - identifierFixup;
            for (int i = this.offset + identifierFixup; i < max; ++i) {
                char c = this.chars.charAt(i);
                if (c == '/') {
                    builder.append('.');
                    continue;
                }
                builder.append(c);
            }
        }
    }

    @Override
    public URI getURI() {
        BinaryTypeSignature typeErasure = this.getArrayComponentType().getTypeErasure();
        String identifier = typeErasure.toIdentifier();
        URI result = URIHelperConstants.OBJECTS_URI.appendSegment(identifier).appendFragment(this.toIdentifier());
        return result;
    }
}

