/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsink;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

@Path(value="stage")
public class StageCheckerResource {
    public static final String DONE = "CompletionStage has been done";

    @GET
    @Produces(value={"text/event-stream"})
    public void send(@Context SseEventSink sink, @Context Sse sse) throws IOException {
        try {
            SseEventSink s = sink;
            try {
                CompletableFuture stage = s.send(sse.newEvent("some_ServiceUnavailableEndpoint_message")).toCompletableFuture();
                while (!stage.isDone()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        sse.newEvent(e.getMessage());
                        if (s != null) {
                            s.close();
                        }
                        return;
                    }
                }
                s.send(sse.newEvent(DONE));
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

