/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.CrossParameterDescriptor;
import jakarta.validation.metadata.GroupConversionDescriptor;
import jakarta.validation.metadata.MethodDescriptor;
import jakarta.validation.metadata.ParameterDescriptor;
import jakarta.validation.metadata.ReturnValueDescriptor;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation.CrossRepositoryConstraint;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation.Customer;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation.CustomerRepository;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class MethodValidationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)MethodValidationTest.webArchiveBuilder().withTestClassPackage(MethodValidationTest.class)).withValidationXml("validation-MethodValidationTest.xml")).withResource("customer-repository-constraints-MethodValidationTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="f")})
    public void testXmlMethodConfigurationApplied() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "listCustomers", new Class[0]);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue());
        Assert.assertFalse((boolean)descriptor.hasConstrainedParameters());
        descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "findCustomer", String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue());
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
        descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "isCustomer", String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertFalse((boolean)descriptor.hasConstrainedReturnValue());
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="c")})
    public void testVarargsMethodParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "addCustomers", Customer[].class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="g"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="k")})
    public void testMethodCrossParameterConstraint() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "notifyCustomer", Customer.class, String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        CrossParameterDescriptor crossParameterDescriptor = descriptor.getCrossParameterDescriptor();
        Assert.assertTrue((boolean)crossParameterDescriptor.hasConstraints());
        Set constraintDescriptors = crossParameterDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), CrossRepositoryConstraint.class, (String)"Unexpected constraint type");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-constraintdescriptor", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="h")})
    public void testConstraintOnMethodReturnValueAndParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "notifyCustomer", Customer.class, String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Set constraintDescriptors = returnValueDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), NotNull.class, (String)"Unexpected constraint type");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 2 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        constraintDescriptors = parameterDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        constraintDescriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), NotNull.class, (String)"Unexpected constraint type");
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="i")
    public void testCascadingOnReturnValueAndParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "findByExample", Customer.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Assert.assertTrue((boolean)returnValueDescriptor.isCascaded(), (String)"<valid/> is used to configure cascading");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        Assert.assertTrue((boolean)parameterDescriptor.isCascaded(), (String)"<valid/> is used to configure cascading");
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="j")
    public void testGroupConversionOnReturnValueAndParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "findByExample", Customer.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Set groupConversionDescriptors = returnValueDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
        GroupConversionDescriptor groupConversionDescriptor = (GroupConversionDescriptor)groupConversionDescriptors.iterator().next();
        Assert.assertEquals((Object)groupConversionDescriptor.getFrom(), Default.class, (String)"Wrong from class for group conversion");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        groupConversionDescriptors = parameterDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
        groupConversionDescriptor = (GroupConversionDescriptor)groupConversionDescriptors.iterator().next();
        Assert.assertEquals((Object)groupConversionDescriptor.getFrom(), Default.class, (String)"Wrong from class for group conversion");
    }
}

