/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class LoggingUtils {
    private static final String LINE_SEPARATOR = "line.separator";

    private LoggingUtils() {
    }

    public static void logInfo(Plugin plugin, String message) {
        LoggingUtils.log(plugin, 1, 0, message, null);
    }

    public static void logError(Plugin plugin, Throwable exception) {
        LoggingUtils.logError(plugin, exception.getMessage(), exception);
    }

    public static void logError(Plugin plugin, String message, Throwable exception) {
        LoggingUtils.log(plugin, 4, 0, message, exception);
    }

    public static void logError(Plugin plugin, String message) {
        LoggingUtils.logError(plugin, message, null);
    }

    public static void log(Plugin plugin, int severity, int code, String message, Throwable exception) {
        LoggingUtils.log(plugin, LoggingUtils.createStatus(plugin, severity, code, message, exception));
    }

    public static void log(Plugin plugin, IStatus status) {
        if (plugin == null) {
            return;
        }
        plugin.getLog().log(status);
    }

    public static IStatus createStatus(Plugin plugin, int severity, int code, String message, Throwable exception) {
        if (plugin == null) {
            return null;
        }
        String pluginId = plugin.getBundle().getSymbolicName();
        return new Status(severity, pluginId, code, message, exception);
    }

    public static IStatus createMultiStatus(Plugin plugin, int severity, String message, Throwable exception) {
        if (plugin == null) {
            return null;
        }
        String pluginId = plugin.getBundle().getSymbolicName();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        String trace = stringWriter.toString();
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        String[] stringArray = trace.split(System.getProperty(LINE_SEPARATOR));
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            childStatuses.add(new Status(severity, pluginId, line));
            ++n2;
        }
        return new MultiStatus(pluginId, 4, childStatuses.toArray(new IStatus[childStatuses.size()]), message, exception);
    }
}

