/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.table.swt.FeatureAwareComparator;
import org.eclipse.emfforms.spi.common.BundleResolver;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.sort.NumberAwareStringComparator;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.osgi.framework.Bundle;

public class LocalizedEnumeratorComparator
implements FeatureAwareComparator<Enumerator> {
    private static final String ENUM_KEY_TEMPLATE = "_UI_%s_%s_literal";
    private final Map<EClassifier, Optional<Bundle>> editBundles = new HashMap<EClassifier, Optional<Bundle>>();
    private final EMFFormsLocalizationService localizationService;
    private final BundleResolver bundleResolver;
    private final ReportService reportService;

    public LocalizedEnumeratorComparator(EMFFormsLocalizationService localizationService, BundleResolver bundleResolver, ReportService reportService) {
        this.localizationService = localizationService;
        this.bundleResolver = bundleResolver;
        this.reportService = reportService;
    }

    @Override
    public int compare(EStructuralFeature feature, Enumerator leftValue, Enumerator rightValue) {
        if (leftValue == null) {
            if (rightValue == null) {
                return 0;
            }
            return 1;
        }
        if (rightValue == null) {
            return -1;
        }
        String typeName = feature.getEType().getName();
        Optional editBundle = this.editBundles.computeIfAbsent(feature.getEType(), key -> {
            try {
                return Optional.of(this.bundleResolver.getEditBundle((EClassifier)feature.getEContainingClass()));
            }
            catch (BundleResolver.NoBundleFoundException ex) {
                this.reportService.report(new AbstractReport(MessageFormat.format("No edit bundle was found for EEnum ''{0}''. Hence, its literals cannot be internationalized for feature ''{1}''.", typeName, feature.getName()), 2));
                return Optional.empty();
            }
        });
        String leftLabel = editBundle.map(eB -> this.localizationService.getString(eB, String.format(ENUM_KEY_TEMPLATE, typeName, leftValue.getName()))).orElse(leftValue.getLiteral());
        String rightLabel = editBundle.map(eB -> this.localizationService.getString(eB, String.format(ENUM_KEY_TEMPLATE, typeName, rightValue.getName()))).orElse(rightValue.getLiteral());
        return NumberAwareStringComparator.getInstance().compare(leftLabel, rightLabel);
    }
}

