/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.workspace.internal.ui;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.spi.ui.CompositeStateObserver;
import org.eclipse.emf.ecp.workspace.internal.ui.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewWorkspaceProjectComposite
extends Composite {
    private final CompositeStateObserver compositeStateObserver;
    private final ECPProperties properties;
    private boolean complete;
    private Text newFileText;
    private Text rootClassText;
    private Text importFileText;
    private Button importButton;
    private StackLayout providerStackLayout;
    private Composite providerStackComposite;
    private Composite newProjectComposite;
    private Composite importProjectComposite;
    private Resource resource;
    private EClass eClass;
    private Composite grpDoYouWant;
    private Label label;

    public NewWorkspaceProjectComposite(Composite parent, CompositeStateObserver observer, ECPProperties projectProperties) {
        super(parent, 0);
        this.properties = projectProperties;
        this.compositeStateObserver = observer;
        this.setLayout((Layout)new GridLayout(1, false));
        this.createStackComposite(parent);
        this.notifyObserver();
    }

    private void createStackComposite(Composite parent) {
        this.providerStackLayout = new StackLayout();
        this.grpDoYouWant = new Composite((Composite)this, 2048);
        this.grpDoYouWant.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.grpDoYouWant.setLayout((Layout)new GridLayout(2, false));
        this.importButton = new Button(this.grpDoYouWant, 16);
        this.importButton.setText(Messages.NewWorkspaceProjectComposite_IMPORT_XMI_FILE);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((NewWorkspaceProjectComposite)NewWorkspaceProjectComposite.this).providerStackLayout.topControl = NewWorkspaceProjectComposite.this.importProjectComposite;
                NewWorkspaceProjectComposite.this.checkStatusChanged();
                NewWorkspaceProjectComposite.this.providerStackComposite.layout();
            }
        });
        this.providerStackComposite = new Composite((Composite)this, 0);
        this.providerStackComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.providerStackComposite.setLayout((Layout)this.providerStackLayout);
        this.createImportWorkspaceProjectComposite(this.providerStackComposite);
        this.providerStackLayout.topControl = this.newProjectComposite;
    }

    private void createImportWorkspaceProjectComposite(final Composite composite) {
        this.importProjectComposite = new Composite(composite, 2048);
        this.importProjectComposite.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.importProjectComposite.setLayout((Layout)new GridLayout(3, false));
        Label selectFileLabel = new Label(this.importProjectComposite, 0);
        selectFileLabel.setText(Messages.NewWorkspaceProjectComposite_SELECT_FILE);
        this.importFileText = new Text(this.importProjectComposite, 2060);
        this.importFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.importFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkspaceProjectComposite.this.checkStatusChanged();
            }
        });
        new Label(this.importProjectComposite, 0);
        Button importFileButton = new Button(this.importProjectComposite, 0);
        importFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(composite.getShell(), 4096);
                fileDialog.setText(Messages.NewWorkspaceProjectComposite_OPEN);
                String path = fileDialog.open();
                if (path != null) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource resource = resourceSet.createResource(URI.createFileURI((String)path));
                    try {
                        resource.load(null);
                        NewWorkspaceProjectComposite.this.importFileText.setText(URI.createFileURI((String)path).toString());
                    }
                    catch (IOException ex) {
                        MessageDialog.openError((Shell)NewWorkspaceProjectComposite.this.getShell(), (String)Messages.NewWorkspaceProjectComposite_ERROR, (String)Messages.NewWorkspaceProjectComposite_ERROR_PARSINGXMIFILE);
                    }
                }
            }
        });
        importFileButton.setText(Messages.NewWorkspaceProjectComposite_BROWSE_FILE_SYSTEM);
    }

    private void notifyObserver() {
        if (this.compositeStateObserver != null) {
            this.compositeStateObserver.compositeChangedState((Composite)this, this.complete, this.properties);
        }
    }

    private void checkStatusChanged() {
        boolean pendingStatus;
        this.properties.addProperty("rootURI", this.importFileText.getText());
        boolean bl = pendingStatus = this.importButton.getSelection() && this.importFileTextStatus();
        if (pendingStatus != this.complete) {
            this.complete = pendingStatus;
            this.notifyObserver();
        }
    }

    private boolean importFileTextStatus() {
        return this.nonEmptyString(this.importFileText.getText());
    }

    private boolean nonEmptyString(String string) {
        return string != null && string.length() > 0 && string.trim().length() == string.length();
    }

    private void fillResource() {
        if (this.resource != null && this.eClass != null) {
            EObject root = EcoreUtil.create((EClass)this.eClass);
            this.resource.getContents().clear();
            this.resource.getContents().add((Object)root);
            try {
                this.resource.save(Collections.singletonMap("ENCODING", "UTF-8"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

