/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.ui.Activator;
import org.eclipse.emf.ecp.view.spi.provider.ECPStringModifier;
import org.osgi.framework.Bundle;

public final class ECPTooltipModifierHelper {
    private static final String CLASS_CANNOT_BE_RESOLVED = "%1$s cannot be loaded because bundle %2$s cannot be resolved.";
    private static final String CLASS = "class";
    private static final String EXTENSION_POINT_ID = "org.eclipse.emf.ecp.ui.view.tooltipModifier";
    private static SortedSet<ECPStringModifier> stringModifiers = new TreeSet<ECPStringModifier>(new Comparator<ECPStringModifier>(){

        @Override
        public int compare(ECPStringModifier arg0, ECPStringModifier arg1) {
            if (arg0.getPriority() == arg1.getPriority()) {
                return arg0.getClass().getName().compareTo(arg1.getClass().getName());
            }
            double compare = arg0.getPriority() - arg1.getPriority();
            return compare < 0.0 ? -1 : 1;
        }
    });

    private ECPTooltipModifierHelper() {
    }

    private static synchronized Set<ECPStringModifier> getStringModifiers() {
        if (stringModifiers == null || stringModifiers.isEmpty()) {
            ECPTooltipModifierHelper.readStringModifiers();
        }
        return stringModifiers;
    }

    private static void readStringModifiers() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String clazz = e.getAttribute(CLASS);
                Class resolvedClass = ECPTooltipModifierHelper.loadClass(e.getContributor().getName(), clazz);
                Constructor controlConstructor = resolvedClass.getConstructor(new Class[0]);
                ECPStringModifier stringModifier = (ECPStringModifier)controlConstructor.newInstance(new Object[0]);
                stringModifiers.add(stringModifier);
            }
            catch (ClassNotFoundException ex) {
                Activator.log(ex);
            }
            catch (NoSuchMethodException ex) {
                Activator.log(ex);
            }
            catch (SecurityException ex) {
                Activator.log(ex);
            }
            catch (InstantiationException ex) {
                Activator.log(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.log(ex);
            }
            catch (IllegalArgumentException ex) {
                Activator.log(ex);
            }
            catch (InvocationTargetException ex) {
                Activator.log(ex);
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.format(CLASS_CANNOT_BE_RESOLVED, clazz, bundleName));
        }
        return bundle.loadClass(clazz);
    }

    public static String modifyString(String text, EStructuralFeature.Setting setting) {
        String returnValue = text;
        for (ECPStringModifier tooltipModifier : ECPTooltipModifierHelper.getStringModifiers()) {
            returnValue = tooltipModifier.modifyString(returnValue, setting);
        }
        return returnValue;
    }
}

