/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.changebroker.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.changebroker.internal.Strategy;
import org.eclipse.emf.ecp.changebroker.spi.ChangeObserver;

public class FeatureStrategy
implements Strategy {
    private final Map<EStructuralFeature, Set<ChangeObserver>> registry = new LinkedHashMap<EStructuralFeature, Set<ChangeObserver>>();
    private final Map<ChangeObserver, Set<EStructuralFeature>> observerToKey = new LinkedHashMap<ChangeObserver, Set<EStructuralFeature>>();

    public void register(ChangeObserver observer, EStructuralFeature feature) {
        if (!this.registry.containsKey(feature)) {
            this.registry.put(feature, new LinkedHashSet());
        }
        this.registry.get(feature).add(observer);
        if (!this.observerToKey.containsKey(observer)) {
            this.observerToKey.put(observer, new LinkedHashSet());
        }
        this.observerToKey.get(observer).add(feature);
    }

    @Override
    public Set<ChangeObserver> getObservers(Notification notification) {
        Object feature = notification.getFeature();
        if (!this.registry.containsKey(feature)) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<ChangeObserver>((Collection)this.registry.get(feature));
    }

    @Override
    public void deregister(ChangeObserver observer) {
        Set<EStructuralFeature> keys = this.observerToKey.remove(observer);
        if (keys == null) {
            return;
        }
        for (EStructuralFeature feature : keys) {
            Set<ChangeObserver> set = this.registry.get(feature);
            set.remove(observer);
            if (!set.isEmpty()) continue;
            this.registry.remove(feature);
        }
    }

    @Override
    public Set<ChangeObserver> getAllObservers() {
        return new LinkedHashSet<ChangeObserver>(this.observerToKey.keySet());
    }
}

