/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.authenticator;

import java.io.IOException;
import java.util.Map;
import org.apache.catalina.Session;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.authenticator.ClusterSingleSignOn;
import org.apache.catalina.ha.authenticator.SingleSignOnMessage;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ClusterSingleSignOnListener
extends ClusterListener {
    private static final Log log = LogFactory.getLog(ClusterSingleSignOnListener.class);
    protected static final String info = "org.apache.catalina.ha.authenticator.ClusterSingleSignOnListener/1.0";
    private ClusterSingleSignOn clusterSSO = null;

    public String getInfo() {
        return info;
    }

    public ClusterSingleSignOn getClusterSSO() {
        return this.clusterSSO;
    }

    public void setClusterSSO(ClusterSingleSignOn clusterSSO) {
        this.clusterSSO = clusterSSO;
    }

    @Override
    public void messageReceived(ClusterMessage myobj) {
        if (myobj != null && myobj instanceof SingleSignOnMessage) {
            SingleSignOnMessage msg = (SingleSignOnMessage)myobj;
            int action = msg.getAction();
            Session session = null;
            GenericPrincipal principal = null;
            if (log.isDebugEnabled()) {
                log.debug("SingleSignOnMessage Received with action " + msg.getAction());
            }
            switch (action) {
                case 1: {
                    session = this.getSession(msg.getSessionId(), msg.getContextName());
                    if (session == null) break;
                    this.clusterSSO.associateLocal(msg.getSsoId(), session);
                    break;
                }
                case 2: {
                    session = this.getSession(msg.getSessionId(), msg.getContextName());
                    if (session == null) break;
                    this.clusterSSO.deregisterLocal(msg.getSsoId(), session);
                    break;
                }
                case 3: {
                    this.clusterSSO.deregisterLocal(msg.getSsoId());
                    break;
                }
                case 4: {
                    if (msg.getPrincipal() != null) {
                        principal = msg.getPrincipal().getPrincipal();
                    }
                    this.clusterSSO.registerLocal(msg.getSsoId(), principal, msg.getAuthType(), msg.getUsername(), msg.getPassword());
                    break;
                }
                case 5: {
                    if (msg.getPrincipal() != null) {
                        principal = msg.getPrincipal().getPrincipal();
                    }
                    this.clusterSSO.updateLocal(msg.getSsoId(), principal, msg.getAuthType(), msg.getUsername(), msg.getPassword());
                    break;
                }
                case 6: {
                    session = this.getSession(msg.getSessionId(), msg.getContextName());
                    if (session == null) break;
                    this.clusterSSO.removeSessionLocal(msg.getSsoId(), session);
                }
            }
        }
    }

    @Override
    public boolean accept(ClusterMessage msg) {
        return msg instanceof SingleSignOnMessage;
    }

    private Session getSession(String sessionId, String ctxname) {
        Map<String, ClusterManager> managers = this.clusterSSO.getCluster().getManagers();
        Session session = null;
        if (ctxname == null) {
            for (Map.Entry<String, ClusterManager> entry : managers.entrySet()) {
                if (entry.getValue() != null) {
                    try {
                        session = entry.getValue().findSession(sessionId);
                    }
                    catch (IOException io) {
                        log.error("Session doesn't exist:" + io);
                    }
                    return session;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Context manager doesn't exist:" + entry.getKey());
            }
        } else {
            ClusterManager mgr = managers.get(ctxname);
            if (mgr != null) {
                try {
                    session = mgr.findSession(sessionId);
                }
                catch (IOException io) {
                    log.error("Session doesn't exist:" + io);
                }
                return session;
            }
            if (log.isErrorEnabled()) {
                log.error("Context manager doesn't exist:" + ctxname);
            }
        }
        return null;
    }
}

