/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.templates.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractWorkspaceHandler;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class UploadTemplateHandler
extends AbstractWorkspaceHandler {
    private static final String THIS_PROCESS_WILL_OVERRIDE_YOUR_EXISTING_TEMPLATES_DO_YOU_WANT_TO_CONTINUE = "This process will override your existing templates in case of collision. Do you want to continue?";
    private static final String OVERRIDE_TEMPLATES = "Override Templates";
    private static final String CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE = "Cannot close input stream to an uploaded file";
    private static final String UPLOAD_ERROR = "Upload error";
    private static final String REASON = "Reason";
    private static final String CANNOT_UPLOAD = "Cannot upload";
    private static final String CANNOT_SAVE_UPLOADED_FILE = "Cannot save uploaded file";
    private static final String UPLOAD_TEMPLATES_ARCHIVE = "Upload Templates Archive";
    private static final Logger error = Logger.getLogger(UploadTemplateHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dlg = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 34);
        dlg.setText(UPLOAD_TEMPLATES_ARCHIVE);
        String projectPath = dlg.open();
        if (projectPath != null && MessageDialog.openConfirm(null, (String)OVERRIDE_TEMPLATES, (String)THIS_PROCESS_WILL_OVERRIDE_YOUR_EXISTING_TEMPLATES_DO_YOU_WANT_TO_CONTINUE)) {
            String fileName = null;
            String[] stringArray = dlg.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block16: {
                    String fullFileName = stringArray[n2];
                    fileName = fullFileName.substring(fullFileName.lastIndexOf(File.separatorChar) + 1);
                    FileInputStream in = null;
                    try {
                        try {
                            in = new FileInputStream(fullFileName);
                            IRepository repository = RepositoryFacade.getInstance().getRepository();
                            String root = "/db/dirigible/templates/";
                            repository.importZip(new ZipInputStream(in), root);
                            this.refreshWorkspace();
                        }
                        catch (Exception e) {
                            error.error(CANNOT_SAVE_UPLOADED_FILE + fileName, (Throwable)e);
                            MessageDialog.openError(null, (String)UPLOAD_ERROR, (String)(CANNOT_UPLOAD + fileName + REASON + e.getMessage()));
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException e2) {
                                    error.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e2);
                                }
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException e) {
                                error.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            error.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

