/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.widgets.connection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.ide.ui.widgets.connection.IConnectionItemResolver;

public abstract class AbstractConnectionItemResolver
implements IConnectionItemResolver {
    private final Map<Object, Boolean> itemVisibilityCache = new HashMap<Object, Boolean>();
    private final Map<Object, Integer> itemLocationCache = new HashMap<Object, Integer>();

    @Override
    public boolean isItemVisible(Object item, boolean useCache) {
        Boolean result = this.itemVisibilityCache.get(item);
        if (result == null || !useCache) {
            result = this.evaluateItemVisibility(item, useCache);
            this.itemVisibilityCache.put(item, result);
        }
        return result;
    }

    public abstract boolean evaluateItemVisibility(Object var1, boolean var2);

    @Override
    public int getItemLocation(Object item, boolean useCache) {
        Integer result = this.itemLocationCache.get(item);
        if (result == null || !useCache) {
            result = this.evaluateItemLocation(item, useCache);
            this.itemLocationCache.put(item, result);
        }
        return result;
    }

    public abstract int evaluateItemLocation(Object var1, boolean var2);

    @Override
    public void clearCache() {
        this.itemVisibilityCache.clear();
        this.itemLocationCache.clear();
    }
}

