/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.flow;

import java.io.InputStream;
import org.eclipse.dirigible.repository.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class FlowsActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(FlowsActivator.class);
    private static final String SCHEDULER_NAME = "org.eclipse.dirigible.runtime.flow-QuartzScheduler";
    private static BundleContext context;

    public void start(BundleContext context) throws Exception {
        FlowsActivator.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        InputStream schedulerConfig = FlowsActivator.class.getResourceAsStream("/scheduler.properties");
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            schedulerFactory.initialize(schedulerConfig);
            Scheduler scheduler = schedulerFactory.getScheduler(SCHEDULER_NAME);
            if (scheduler != null) {
                scheduler.shutdown();
            }
        }
        finally {
            block10: {
                if (schedulerConfig != null) {
                    try {
                        schedulerConfig.close();
                    }
                    catch (Exception exception) {
                        if (!logger.isErrorEnabled()) break block10;
                        logger.error("Cannot close the stream to the scheduler configuration.", (Throwable)exception);
                    }
                }
            }
        }
    }

    public static BundleContext getContext() {
        return context;
    }
}

