/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sourceforge.plantuml.eclipse.utils.ILinkOpener;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class DefaultLinkOpener
implements ILinkOpener {
    private boolean preferInternal = false;

    @Override
    public int supportsLink(LinkData link) {
        try {
            URI uri = new URI(link.href);
            if (uri.getScheme() != null) {
                return 0;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public void openLink(LinkData link) {
        try {
            URL url = new URL(link.href);
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = this.preferInternal ? browserSupport.createBrowser(64, "plantuml", "PlantUML Browser", null) : browserSupport.getExternalBrowser();
            browser.openURL(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

