/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntClasspathTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntEnvironmentTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntJRETab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntMainTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntPropertiesTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsBuildTab;

public class AntTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean captureOutput = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", true);
            if (!captureOutput && configuration instanceof ILaunchConfigurationWorkingCopy) {
                ILaunchConfigurationWorkingCopy copy = (ILaunchConfigurationWorkingCopy)configuration;
                copy.setAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", null);
                copy.setAttribute("org.eclipse.debug.core.capture_output", false);
                copy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            }
        }
        catch (CoreException coreException) {}
        super.initializeFrom(configuration);
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        RefreshTab refresh = new RefreshTab();
        refresh.setHelpContextId("org.eclipse.ant.ui.ant_refresh_tab_context");
        ExternalToolsBuildTab build = new ExternalToolsBuildTab();
        build.setHelpContextId("org.eclipse.ant.ui.ant_build_tab_context");
        AntClasspathTab classpath = new AntClasspathTab();
        classpath.setHelpContextId("org.eclipse.ant.ui.ant_classpath_tab_context");
        AntJRETab jre = new AntJRETab();
        jre.setHelpContextId("org.eclipse.ant.ui.ant_jre_tab_context");
        AntEnvironmentTab env = new AntEnvironmentTab();
        env.setHelpContextId("org.eclipse.ant.ui.ant_environment_tab_context");
        CommonTab common = new CommonTab();
        common.setHelpContextId("org.eclipse.ant.ui.ant_common_tab_context");
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new AntMainTab(), refresh, build, new AntTargetsTab(), classpath, new AntPropertiesTab(), jre, env, common};
        this.setTabs(tabs);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IFile file;
        IResource resource = DebugUITools.getSelectedResource();
        if (resource != null && resource instanceof IFile && AntUtil.isKnownAntFile((IResource)(file = (IFile)resource))) {
            String projectName = file.getProject().getName();
            StringBuilder buffer = new StringBuilder(projectName);
            buffer.append(' ');
            buffer.append(file.getName());
            String name = buffer.toString().trim();
            name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(name);
            configuration.rename(name);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", file.getFullPath().toString()));
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        super.setDefaults(configuration);
    }
}

