/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.preferences.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.dialogs.filteredtree.FilteredTree;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.spy.preferences.model.PreferenceEntry;
import org.eclipse.pde.spy.preferences.model.PreferenceEntryManager;
import org.eclipse.pde.spy.preferences.model.PreferenceEntryPatternFilter;
import org.eclipse.pde.spy.preferences.model.PreferenceNodeEntry;
import org.eclipse.pde.spy.preferences.parts.Messages;
import org.eclipse.pde.spy.preferences.viewer.PreferenceEntriesContentProvider;
import org.eclipse.pde.spy.preferences.viewer.PreferenceEntryViewerComparator;
import org.eclipse.pde.spy.preferences.viewer.PreferenceMapLabelProvider;
import org.eclipse.pde.spy.preferences.viewer.PreferenceSpyEditingSupport;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class PreferenceSpyPart {
    private FilteredTree filteredTree;
    private boolean hierarchicalLayoutPreference;
    private PreferenceEntryManager preferenceEntryManager;

    @PostConstruct
    public void postConstruct(Composite parent, final ESelectionService selectionService, EModelService modelService, MWindow window) {
        this.preferenceEntryManager = new PreferenceEntryManager();
        PreferenceEntryPatternFilter patternFilter = new PreferenceEntryPatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        this.filteredTree = new FilteredTree(parent, 2818, (PatternFilter)patternFilter);
        Tree table = this.filteredTree.getViewer().getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.filteredTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    ArrayList preferenceEntries = new ArrayList(((IStructuredSelection)selection).toList());
                    selectionService.setSelection(preferenceEntries);
                }
            }
        });
        this.createColumn(PreferenceEntry.Fields.nodePath, Messages.PreferenceSpyPart_Nodepath, 300);
        this.createColumn(PreferenceEntry.Fields.key, Messages.PreferenceSpyPart_Key, 300);
        this.createColumn(PreferenceEntry.Fields.oldValue, Messages.PreferenceSpyPart_Old_Value, 150);
        this.createColumn(PreferenceEntry.Fields.newValue, Messages.PreferenceSpyPart_New_Value, 150);
        this.filteredTree.getViewer().setComparator((ViewerComparator)new PreferenceEntryViewerComparator());
        FontDescriptor fontDescriptor = this.getBoldFontDescriptor();
        Realm realm = DisplayRealm.getRealm((Display)this.filteredTree.getViewer().getControl().getDisplay());
        PreferenceEntriesContentProvider contentProvider = new PreferenceEntriesContentProvider(BeanProperties.set((String)"preferenceEntries", PreferenceNodeEntry.class).setFactory(realm), null);
        contentProvider.setHierarchicalLayout(this.hierarchicalLayoutPreference);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)contentProvider);
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new PreferenceMapLabelProvider(fontDescriptor, Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])BeanProperties.values(PreferenceEntry.class, (String[])new String[]{"nodePath", "key", "oldValue", "newValue"}))));
        this.filteredTree.getViewer().setInput((Object)this.preferenceEntryManager);
    }

    private FontDescriptor getBoldFontDescriptor() {
        Font origFont = this.filteredTree.getViewer().getControl().getFont();
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)origFont);
        return fontDescriptor.setStyle(1);
    }

    private void createColumn(PreferenceEntry.Fields field, String columnName, int width) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.filteredTree.getViewer(), 0);
        viewerColumn.getColumn().setWidth(width);
        viewerColumn.getColumn().setText(columnName);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        viewerColumn.setEditingSupport((EditingSupport)new PreferenceSpyEditingSupport((ColumnViewer)this.filteredTree.getViewer(), field));
    }

    @Inject
    public void layoutChanged(@Preference(value="hierarchicalLayoutPreference") boolean hierarchicalLayoutPreference) {
        this.hierarchicalLayoutPreference = hierarchicalLayoutPreference;
        if (this.filteredTree != null && !this.filteredTree.getViewer().getControl().isDisposed()) {
            PreferenceEntriesContentProvider contentProvider = (PreferenceEntriesContentProvider)this.filteredTree.getViewer().getContentProvider();
            contentProvider.setHierarchicalLayout(hierarchicalLayoutPreference);
            this.filteredTree.getViewer().refresh();
        }
    }

    @Inject
    @Optional
    public void preferenceChanged(@UIEventTopic(value="TOPIC_PREFERENCESPY/PREFERENCE/CHANGED") IEclipsePreferences.PreferenceChangeEvent event) {
        PreferenceNodeEntry preferenceNodeEntry = this.preferenceEntryManager.getRecentPreferenceNodeEntry(event.getNode().absolutePath());
        PreferenceEntry preferenceEntry = new PreferenceEntry(event.getNode().absolutePath(), event.getKey());
        preferenceEntry.setRecentlyChanged(true);
        if (preferenceNodeEntry == null) {
            preferenceNodeEntry = new PreferenceNodeEntry(event.getNode().absolutePath());
            preferenceNodeEntry.setRecentlyChanged(true);
            preferenceNodeEntry.addChildren(preferenceEntry);
            preferenceEntry.setParent(preferenceNodeEntry);
            this.preferenceEntryManager.addChildren(preferenceNodeEntry);
            this.filteredTree.getViewer().setInput((Object)this.preferenceEntryManager);
            this.preferenceEntryManager.putRecentPreferenceEntry(event.getNode().absolutePath(), preferenceNodeEntry);
        } else {
            preferenceEntry.setParent(preferenceNodeEntry);
            PreferenceEntry existingPreferenceEntry = this.findPreferenceEntry(preferenceEntry);
            if (existingPreferenceEntry != null) {
                preferenceEntry = existingPreferenceEntry;
            } else {
                preferenceNodeEntry.addChildren(preferenceEntry);
            }
        }
        preferenceEntry.setOldValue(String.valueOf(event.getOldValue()));
        preferenceEntry.setNewValue(String.valueOf(event.getNewValue()));
        long currentTimeMillis = System.currentTimeMillis();
        preferenceEntry.setTime(currentTimeMillis);
        preferenceEntry.getParent().setTime(currentTimeMillis);
        this.filteredTree.getViewer().refresh();
    }

    private PreferenceEntry findPreferenceEntry(PreferenceEntry preferenceEntry) {
        PreferenceEntry parent = preferenceEntry.getParent();
        if (parent instanceof PreferenceNodeEntry) {
            IObservableSet<Object> preferenceEntries = ((PreferenceNodeEntry)parent).getPreferenceEntries();
            for (Object object : preferenceEntries) {
                PreferenceEntry existingPreferenceEntry;
                if (!(object instanceof PreferenceEntry) || !(existingPreferenceEntry = (PreferenceEntry)object).getKey().equals(preferenceEntry.getKey())) continue;
                return existingPreferenceEntry;
            }
        }
        return null;
    }

    @Inject
    @Optional
    public void preferenceChanged(@UIEventTopic(value="TOPIC_PREFERENCESPY/PREFERENCE/SHOW") Collection<PreferenceEntry> preferenceEntries) {
        this.preferenceEntryManager.addChildren(preferenceEntries);
        this.filteredTree.getViewer().refresh();
    }

    @Inject
    @Optional
    public void DeletePreferenceEntries(@UIEventTopic(value="TOPIC_PREFERENCESPY/PREFERENCE_ENTRIES/DELETE") List<PreferenceEntry> preferenceEntries) {
        if (preferenceEntries != null && !preferenceEntries.isEmpty()) {
            for (PreferenceEntry preferenceEntry : preferenceEntries) {
                this.preferenceEntryManager.removeChildren(preferenceEntry);
            }
            this.preferenceEntryManager.removeChildren(preferenceEntries);
            this.filteredTree.getViewer().refresh();
        }
    }

    @Inject
    @Optional
    public void DeleteAllPreferenceEntries(@UIEventTopic(value="TOPIC_PREFERENCESPY/PREFERENCE_ENTRIES/DELETE_ALL") List<PreferenceEntry> preferenceEntries) {
        if (this.preferenceEntryManager != null) {
            this.preferenceEntryManager.clearRecentPreferenceNodeEntry();
            this.preferenceEntryManager.getPreferenceEntries().clear();
            this.filteredTree.getViewer().refresh();
        }
    }

    public TreeViewer getViewer() {
        return this.filteredTree.getViewer();
    }
}

