/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.builder.MethodLeakDetector;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public class LeakReturnTypeDetector
extends MethodLeakDetector {
    public LeakReturnTypeDetector(Set<String> nonApiPackageNames) {
        super(nonApiPackageNames);
    }

    @Override
    protected String getSeverityKey() {
        return "LEAK_METHOD_RETURN_TYPE";
    }

    @Override
    public int getReferenceKinds() {
        return 8;
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        return 4;
    }

    @Override
    protected boolean isProblem(IReference reference) {
        if (super.isProblem(reference)) {
            return true;
        }
        IApiType type = (IApiType)reference.getResolvedReference();
        int modifiers = type.getModifiers();
        return Flags.isPackageDefault((int)modifiers);
    }
}

