/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emf;

import java.io.IOException;
import org.apache.poi.hemf.draw.HemfDrawProperties;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emf.HemfDraw;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordType;
import org.apache.poi.hwmf.record.HwmfDraw;
import org.apache.poi.hwmf.record.HwmfRegionMode;
import org.apache.poi.hwmf.record.HwmfWindowing;
import org.apache.poi.util.LittleEndianInputStream;

public class HemfWindowing {

    public static class EmfSelectClipPath
    implements HemfRecord {
        protected HwmfRegionMode regionMode;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.selectClipPath;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.regionMode = HwmfRegionMode.valueOf(leis.readInt());
            return 4L;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            HemfDrawProperties prop = ctx.getProperties();
            ctx.setClip(prop.getPath(), this.regionMode, false);
        }

        public String toString() {
            return "{ regionMode: '" + (Object)((Object)this.regionMode) + "' }";
        }
    }

    public static class EmfScaleWindowExtEx
    extends HwmfWindowing.WmfScaleWindowExt
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.scaleWindowExtEx;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            double xNum = leis.readInt();
            double xDenom = leis.readInt();
            double yNum = leis.readInt();
            double yDenom = leis.readInt();
            this.scale.setSize(xNum / xDenom, yNum / yDenom);
            return 16L;
        }
    }

    public static class EmfScaleViewportExtEx
    extends HwmfWindowing.WmfScaleViewportExt
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.scaleViewportExtEx;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            double xNum = leis.readInt();
            double xDenom = leis.readInt();
            double yNum = leis.readInt();
            double yDenom = leis.readInt();
            this.scale.setSize(xNum / xDenom, yNum / yDenom);
            return 16L;
        }
    }

    public static class EmfSetIntersectClipRect
    extends HwmfWindowing.WmfIntersectClipRect
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setIntersectClipRect;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfDraw.readRectL(leis, HwmfDraw.normalizeBounds(this.bounds));
        }
    }

    public static class EmfSetExcludeClipRect
    extends HwmfWindowing.WmfExcludeClipRect
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setExcludeClipRect;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfDraw.readRectL(leis, this.bounds);
        }
    }

    public static class EmfSetOffsetClipRgn
    extends HwmfWindowing.WmfOffsetClipRgn
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setOffsetClipRgn;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfDraw.readPointL(leis, this.offset);
        }
    }

    public static class EmfSetViewportOrgEx
    extends HwmfWindowing.WmfSetViewportOrg
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setViewportOrgEx;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfDraw.readPointL(leis, this.origin);
        }
    }

    public static class EmfSetViewportExtEx
    extends HwmfWindowing.WmfSetViewportExt
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setViewportExtEx;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfDraw.readDimensionInt(leis, this.extents);
        }
    }

    public static class EmfSetWindowOrgEx
    extends HwmfWindowing.WmfSetWindowOrg
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setWindowOrgEx;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfDraw.readPointL(leis, this.origin);
        }
    }

    public static class EmfSetWindowExtEx
    extends HwmfWindowing.WmfSetWindowExt
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setWindowExtEx;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfDraw.readDimensionInt(leis, this.size);
        }
    }
}

