/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.launching.IPDEConstants;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationListener;
import org.eclipse.pde.internal.launching.launcher.LaunchListener;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.internal.launching.launcher.OSGiFrameworkManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class PDELaunchingPlugin
extends Plugin
implements IPDEConstants {
    private static PDELaunchingPlugin fInstance;
    private LaunchListener fLaunchListener;
    private BundleContext fBundleContext;
    private DebugPluginUtil fDebugPluginUtil;
    private OSGiFrameworkManager fOSGiFrameworkManager;
    private PDEPreferencesManager fPreferenceManager;

    public PDELaunchingPlugin() {
        fInstance = this;
    }

    public PDEPreferencesManager getPreferenceManager() {
        if (this.fPreferenceManager == null) {
            this.fPreferenceManager = new PDEPreferencesManager("org.eclipse.pde.launching");
        }
        return this.fPreferenceManager;
    }

    public static PDELaunchingPlugin getDefault() {
        return fInstance;
    }

    public static String getPluginId() {
        return PDELaunchingPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PDELaunchingPlugin.getPluginId(), 0, e.getMessage(), e);
        PDELaunchingPlugin.log(status);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        this.setupLaunchConfigurationListener();
    }

    private void setupLaunchConfigurationListener() {
        boolean listenerStarted = false;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.debug.core");
        if (bundle != null && bundle.getState() == 32) {
            this.fDebugPluginUtil = new DebugPluginUtil();
            this.fDebugPluginUtil.addListener();
            listenerStarted = true;
        }
        if (!listenerStarted) {
            this.fBundleContext.addBundleListener(new BundleListener(){

                public void bundleChanged(BundleEvent event) {
                    if (event.getType() == 2 && "org.eclipse.debug.core".equals(event.getBundle().getSymbolicName())) {
                        PDELaunchingPlugin.this.fDebugPluginUtil = new DebugPluginUtil();
                        PDELaunchingPlugin.this.fDebugPluginUtil.addListener();
                        PDELaunchingPlugin.this.fBundleContext.removeBundleListener((BundleListener)this);
                    }
                }
            });
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fLaunchListener != null) {
            this.fLaunchListener.shutdown();
        }
        if (this.fDebugPluginUtil != null) {
            this.fDebugPluginUtil.removeListener();
        }
        LauncherUtils.shutdown();
        super.stop(context);
    }

    public LaunchListener getLaunchListener() {
        if (this.fLaunchListener == null) {
            this.fLaunchListener = new LaunchListener();
        }
        return this.fLaunchListener;
    }

    public OSGiFrameworkManager getOSGiFrameworkManager() {
        if (this.fOSGiFrameworkManager == null) {
            this.fOSGiFrameworkManager = new OSGiFrameworkManager();
        }
        return this.fOSGiFrameworkManager;
    }

    private class DebugPluginUtil {
        private ILaunchConfigurationListener fLaunchConfigurationListener;

        private DebugPluginUtil() {
        }

        public void addListener() {
            if (this.fLaunchConfigurationListener == null) {
                this.fLaunchConfigurationListener = new LaunchConfigurationListener();
            }
            DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.fLaunchConfigurationListener);
        }

        public void removeListener() {
            if (this.fLaunchConfigurationListener != null) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.fLaunchConfigurationListener);
                this.fLaunchConfigurationListener = null;
            }
        }
    }
}

