/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.contentassist;

import com.google.inject.Inject;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.project.project.GeneratorBlock;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.ui.contentassist.AbstractProjectProposalProvider;
import org.eclipse.comma.project.ui.contentassist.HtmlConfigurableCompletionProposal;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.Functions;

public class TaskProposalProvider
extends AbstractProjectProposalProvider {
    @Inject
    private IScopeProvider scopeProvider;
    private final Image templateIcon;
    public static String INAME = "IName";
    private final int TEMPLATE_DEFAULT_PRIORITY = 600;
    protected static String GENERATE_MONITORING_INFO = "Task for monitoring";
    protected static String GENERATE_MAPPINGS_INFO = "Type Mappings for generation.";
    protected static String GENERATE_MAPPINGS_SIMPLE_INFO = "Type Mappings for generation with Simple Type suggestions";
    protected static String GENERATE_DOCUMENTATION_INFO = "Task for how to generate the documentation";
    protected static String GENERATE_STUB_INFO = "Task for generating Stub and UI CPP code.";
    protected static String GENERATE_UML_INFO = "Task for generating Plant UML images.";
    protected final String TASK_SIMULATION = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("simulation for interface %s");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_UML = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("umlTask for interface %s");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_STUB_INTERFACE = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("stubTask for interface %s {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// exclude command: <Provide command Names that you want to exclude>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// exclude signal: <Provide signal Names that you want to exclude>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// exclude notification: <Provide notification names that you want to exclude>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("latency: 10 seconds // Polling delay of the simulation | stub behavior");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("parameters file: \"file.params\" // Provide the correct name of the input parameters file");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("auto-launch-console: NO // Build and launch of the console simulation on Execute CommaSuite Workflow?");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("auto-launch-gui: NO // Build and launch of the GUI simulation on Execute CommaSuite Workflow?");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// The following attribute is OPTIONAL. ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// It is used to specify a different location for the BAT File: vcvarsall.bat [located in your Visual Studio Installation]");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// If not specified then the default path is assumed, i.e. \"C:\\\\Program Files (x86)\\\\Microsoft Visual Studio\\\\2017\\\\Community\\\\VC\\\\Auxiliary\\\\Build\\\\\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// msvc-install-path: \"C:\\\\Program Files (x86)\\\\Microsoft Visual Studio\\\\2017\\\\Community\\\\VC\\\\Auxiliary\\\\Build\\\\\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("overwrite-server-stub-helper: YES // Overwrite the helper file generated by the server stub?");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("overwrite-client-stub-adapter: YES // Overwrite the generated client stub adapter implementation?");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_MONITOR = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("monitoring for interface %s {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("trace files");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"file.events\"");
            _builder.newLine();
            _builder.append("}");
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_TYPE_MAPPINGS = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("typeMappings {");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("}");
            return _builder.toString();
        }
    }.apply();
    protected final String COMPOUND_INTERFACE = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("ICompound {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("version");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"0.1\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("description");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"Description\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("interfaces");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("%s");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    protected final String TASK_INPUT_TEMPLATE = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("inputTemplateTask for interface %s");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();

    @Override
    public void complete_MonitoringTask(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        super.complete_MonitoringTask(model, ruleCall, context, acceptor);
        this.acceptMonitoringTask(INAME, context, acceptor);
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                TaskProposalProvider.this.acceptMonitoringTask(it.getName(), context, acceptor);
            }
        };
        this.getInterfaces(model).forEach(_function);
    }

    public void acceptMonitoringTask(String name, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposalSimple = String.format(this.TASK_MONITOR, name);
        acceptor.accept((ICompletionProposal)this.createTemplate("Monitoring Task " + name, proposalSimple, GENERATE_MONITORING_INFO, 2, context));
    }

    @Override
    public void complete_DocumentationGenerationTask(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        String proposal = String.format(this.getDocumentationTask(), INAME);
        acceptor.accept((ICompletionProposal)this.createTemplate("Documentation Task Example", proposal, GENERATE_DOCUMENTATION_INFO, 1, context));
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                TaskProposalProvider.this.acceptDocumenationTask(it.getName(), context, acceptor);
            }
        };
        this.getInterfaces(model).forEach(_function);
    }

    public void acceptDocumenationTask(String iName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposal = String.format(this.getDocumentationTask(), iName);
        acceptor.accept((ICompletionProposal)this.createTemplate("Documentation Task for interface " + iName, proposal, "", 1, context));
    }

    @Override
    public void complete_UMLTask(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        this.acceptUMLTask(INAME, context, acceptor);
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                TaskProposalProvider.this.acceptUMLTask(it.getName(), context, acceptor);
            }
        };
        this.getInterfaces(model).forEach(_function);
    }

    public void acceptUMLTask(String name, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposalSimple = String.format(this.TASK_UML, name);
        acceptor.accept((ICompletionProposal)this.createTemplate("UML Task " + name, proposalSimple, GENERATE_UML_INFO, 2, context));
    }

    public void acceptCPPStubAndUITask(String name, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposalSimple = String.format(this.TASK_STUB_INTERFACE, name);
        acceptor.accept((ICompletionProposal)this.createTemplate("Stub and UI Task " + name, proposalSimple, GENERATE_STUB_INFO, 2, context));
    }

    @Override
    public void complete_CompoundInterface(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        super.complete_CompoundInterface(model, ruleCall, context, acceptor);
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                TaskProposalProvider.this.acceptCompoundInterface(it.getName(), context, acceptor);
            }
        };
        this.getInterfaces(model).forEach(_function);
    }

    public void acceptCompoundInterface(String iName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposal = String.format(this.COMPOUND_INTERFACE, iName);
        acceptor.accept((ICompletionProposal)this.createTemplate("Compound Interface with interface" + iName, proposal, "", 2, context));
    }

    public TaskProposalProvider() {
        this.templateIcon = ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.comma.icons").getResource("icons/template.png")).createImage();
    }

    protected HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context) {
        return this.createTemplate(name, content, additionalInfo, nrIndents, context, 600);
    }

    protected String addIndents(String content, Integer nrIndents, boolean newLine) {
        String _xblockexpression = null;
        String indent = "";
        int i = 0;
        while (i < nrIndents) {
            String _indent = indent;
            indent = String.valueOf(_indent) + "\t";
            ++i;
        }
        String _lineSeparator = System.lineSeparator();
        String _lineSeparator_1 = System.lineSeparator();
        String _plus = String.valueOf(_lineSeparator_1) + indent;
        String indentedContent = content.replace(_lineSeparator, _plus);
        if (newLine) {
            String _lineSeparator_2 = System.lineSeparator();
            String _plus_1 = String.valueOf(_lineSeparator_2) + indent;
            return String.valueOf(_plus_1) + indentedContent;
        }
        _xblockexpression = String.valueOf(indent) + indentedContent;
        return _xblockexpression;
    }

    private HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context, int priority) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        String indentedContent = this.addIndents(content, nrIndents, true);
        while (indentedContent.startsWith("\n") || indentedContent.startsWith("\r") || indentedContent.startsWith("\t")) {
            indentedContent = indentedContent.substring(1);
        }
        String finalAdditionalInfo = content;
        StyledString _styledString = new StyledString(name);
        HtmlConfigurableCompletionProposal proposal = this.createHtmlCompletionProposal(indentedContent, _styledString, this.templateIcon, 600, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            finalAdditionalInfo = "<html><body bgcolor=\"#FFFFE1\"><style> body { font-size:9pt; font-family:'Segoe UI' }</style><pre>" + finalAdditionalInfo + "</pre>";
            if (additionalInfo != null) {
                finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "<p>" + additionalInfo + "</p>";
            }
            finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "</body></html>";
            proposal.setAdditionalProposalInfo(finalAdditionalInfo);
            proposal.setProposalContextResource((Resource)context.getResource());
            proposal.setPriority(priority);
        }
        _xblockexpression = proposal;
        return _xblockexpression;
    }

    private HtmlConfigurableCompletionProposal createHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        boolean _isValidProposal = this.isValidProposal(proposal, context.getPrefix(), context);
        if (_isValidProposal) {
            return this.doCreateHtmlCompletionProposal(proposal, displayString, image, priority, context);
        }
        return null;
    }

    private HtmlConfigurableCompletionProposal doCreateHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        int _length = proposal.length();
        HtmlConfigurableCompletionProposal result = new HtmlConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, _length, image, displayString, null, null);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        result.setReplaceContextLength(context.getReplaceContextLength());
        _xblockexpression = result;
        return _xblockexpression;
    }

    public boolean containsBlock(EObject model, EClass blockClass) {
        if (model instanceof Project) {
            EList _generatorBlocks = ((Project)model).getGeneratorBlocks();
            for (GeneratorBlock block : _generatorBlocks) {
                boolean _tripleEquals;
                EClass _eClass = block.eClass();
                boolean bl = _tripleEquals = _eClass == blockClass;
                if (!_tripleEquals) continue;
                return true;
            }
        }
        return false;
    }

    public String getDocumentationTask() {
        return "";
    }

    public List<Interface> getInterfaces(EObject model) {
        return ComponentUtilities.getAllInterfaces((EObject)model, (IScopeProvider)this.scopeProvider);
    }
}

