/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntObjectProcedure;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImmutableIntObjectMap<V>
implements ImmutableIntObjectMap<V> {
    public <V1> ObjectLongMap<V1> sumByInt(Function<V, V1> groupBy, IntFunction<? super V> function) {
        ObjectLongHashMap result = ObjectLongHashMap.newMap();
        return (ObjectLongMap)this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    public <V1> ObjectDoubleMap<V1> sumByFloat(Function<V, V1> groupBy, FloatFunction<? super V> function) {
        ObjectDoubleHashMap result = ObjectDoubleHashMap.newMap();
        return (ObjectDoubleMap)this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    public <V1> ObjectLongMap<V1> sumByLong(Function<V, V1> groupBy, LongFunction<? super V> function) {
        ObjectLongHashMap result = ObjectLongHashMap.newMap();
        return (ObjectLongMap)this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    public <V1> ObjectDoubleMap<V1> sumByDouble(Function<V, V1> groupBy, DoubleFunction<? super V> function) {
        ObjectDoubleHashMap result = ObjectDoubleHashMap.newMap();
        return (ObjectDoubleMap)this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ImmutableIntObjectMapSerializationProxy<V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntObjectMap<V> map;

        public ImmutableIntObjectMapSerializationProxy() {
        }

        protected ImmutableIntObjectMapSerializationProxy(IntObjectMap<V> map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((IntObjectProcedure)new CheckedIntObjectProcedure<V>(){

                    @Override
                    public void safeValue(int key, V value) throws IOException {
                        out.writeInt(key);
                        out.writeObject(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntObjectHashMap deserializedMap = new IntObjectHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readInt(), in.readObject());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

