/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.FlatCollectFloatToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectFloatIterable;

public final class LazyFloatIterate {
    private static final LazyFloatIterable EMPTY_ITERABLE = FloatLists.immutable.empty().asLazy();

    private LazyFloatIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyFloatIterable adapt(FloatIterable iterable) {
        return new LazyFloatIterableAdapter(iterable);
    }

    public static LazyFloatIterable select(FloatIterable iterable, FloatPredicate predicate) {
        return new SelectFloatIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(FloatIterable iterable, FloatToObjectFunction<? extends V> function) {
        return new CollectFloatToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> flatCollect(FloatIterable iterable, FloatToObjectFunction<? extends Iterable<V>> function) {
        return new FlatCollectFloatToObjectIterable(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(FloatIterable iterable, FloatPredicate predicate, FloatToObjectFunction<? extends V> function) {
        return LazyFloatIterate.select(iterable, predicate).collect((FloatToObjectFunction)function);
    }

    public static LazyFloatIterable empty() {
        return EMPTY_ITERABLE;
    }
}

