/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableFloatList extends ImmutableFloatCollection, FloatList
{
    @Override
    ImmutableFloatList select(FloatPredicate predicate);

    @Override
    ImmutableFloatList reject(FloatPredicate predicate);

    @Override
    <V> ImmutableList<V> collect(FloatToObjectFunction<? extends V> function);

    @Override
    ImmutableFloatList newWith(float element);

    @Override
    ImmutableFloatList newWithout(float element);

    @Override
    ImmutableFloatList newWithAll(FloatIterable elements);

    @Override
    ImmutableFloatList newWithoutAll(FloatIterable elements);

    @Override
    ImmutableFloatList toReversed();

    /**
     * @since 6.0.
     */
    @Override
    ImmutableFloatList distinct();

    @Override
    ImmutableFloatList subList(int fromIndex, int toIndex);
}
