/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableDoubleStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableDoubleArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableDoubleEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableDoubleSingletonStack;

public class ImmutableDoubleStackFactoryImpl
implements ImmutableDoubleStackFactory {
    @Override
    public ImmutableDoubleStack empty() {
        return ImmutableDoubleEmptyStack.INSTANCE;
    }

    @Override
    public ImmutableDoubleStack of() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleStack with() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleStack of(double one) {
        return this.with(one);
    }

    @Override
    public ImmutableDoubleStack with(double one) {
        return new ImmutableDoubleSingletonStack(one);
    }

    @Override
    public ImmutableDoubleStack of(double ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableDoubleStack with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleArrayStack.newStackWith(items);
    }

    @Override
    public ImmutableDoubleStack ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableDoubleStack withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleStack) {
            return (ImmutableDoubleStack)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableDoubleStack ofAllReversed(DoubleIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public ImmutableDoubleStack withAllReversed(DoubleIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableDoubleArrayStack.newStackFromTopToBottom(items);
    }
}

