/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.factory.map.primitive.MutableByteCharMapFactory;
import org.eclipse.collections.api.map.primitive.ByteCharMap;
import org.eclipse.collections.api.map.primitive.MutableByteCharMap;
import org.eclipse.collections.impl.factory.primitive.ByteCharMaps;
import org.eclipse.collections.impl.map.mutable.primitive.ByteCharHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableByteCharMapFactoryImpl implements MutableByteCharMapFactory
{
    INSTANCE;


    @Override
    public MutableByteCharMap empty() {
        return new ByteCharHashMap(0);
    }

    @Override
    public MutableByteCharMap of() {
        return this.empty();
    }

    @Override
    public MutableByteCharMap with() {
        return this.empty();
    }

    @Override
    public MutableByteCharMap ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    @Override
    public MutableByteCharMap withInitialCapacity(int capacity) {
        return new ByteCharHashMap(capacity);
    }

    @Override
    public MutableByteCharMap ofAll(ByteCharMap map) {
        return this.withAll(map);
    }

    @Override
    public MutableByteCharMap withAll(ByteCharMap map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new ByteCharHashMap(map);
    }

    @Override
    public <T> MutableByteCharMap from(Iterable<T> iterable, ByteFunction<? super T> keyFunction, CharFunction<? super T> valueFunction) {
        MutableByteCharMap map = ByteCharMaps.mutable.empty();
        Iterate.forEach(iterable, each -> map.put(keyFunction.byteValueOf(each), valueFunction.charValueOf(each)));
        return map;
    }
}

