/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable;

import java.util.Objects;
import org.eclipse.collections.api.factory.set.ImmutableSetFactory;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.set.immutable.ImmutableDoubletonSet;
import org.eclipse.collections.impl.set.immutable.ImmutableEmptySet;
import org.eclipse.collections.impl.set.immutable.ImmutableQuadrupletonSet;
import org.eclipse.collections.impl.set.immutable.ImmutableSingletonSet;
import org.eclipse.collections.impl.set.immutable.ImmutableTripletonSet;
import org.eclipse.collections.impl.set.immutable.ImmutableUnifiedSet;
import org.eclipse.collections.impl.utility.Iterate;

public class ImmutableSetFactoryImpl
implements ImmutableSetFactory {
    public static final ImmutableSetFactory INSTANCE = new ImmutableSetFactoryImpl();

    @Override
    public <T> ImmutableSet<T> empty() {
        return ImmutableEmptySet.INSTANCE;
    }

    @Override
    public <T> ImmutableSet<T> of() {
        return this.empty();
    }

    @Override
    public <T> ImmutableSet<T> with() {
        return this.empty();
    }

    @Override
    public <T> ImmutableSet<T> of(T one) {
        return this.with(one);
    }

    @Override
    public <T> ImmutableSet<T> with(T one) {
        return new ImmutableSingletonSet<T>(one);
    }

    @Override
    public <T> ImmutableSet<T> of(T one, T two) {
        return this.with(one, two);
    }

    @Override
    public <T> ImmutableSet<T> with(T one, T two) {
        if (Objects.equals(one, two)) {
            return this.of(one);
        }
        return new ImmutableDoubletonSet<T>(one, two);
    }

    @Override
    public <T> ImmutableSet<T> of(T one, T two, T three) {
        return this.with(one, two, three);
    }

    @Override
    public <T> ImmutableSet<T> with(T one, T two, T three) {
        if (Objects.equals(one, two)) {
            return this.of(one, three);
        }
        if (Objects.equals(one, three)) {
            return this.of(one, two);
        }
        if (Objects.equals(two, three)) {
            return this.of(one, two);
        }
        return new ImmutableTripletonSet<T>(one, two, three);
    }

    @Override
    public <T> ImmutableSet<T> of(T one, T two, T three, T four) {
        return this.with(one, two, three, four);
    }

    @Override
    public <T> ImmutableSet<T> with(T one, T two, T three, T four) {
        if (Objects.equals(one, two)) {
            return this.of(one, three, four);
        }
        if (Objects.equals(one, three)) {
            return this.of(one, two, four);
        }
        if (Objects.equals(one, four)) {
            return this.of(one, two, three);
        }
        if (Objects.equals(two, three)) {
            return this.of(one, two, four);
        }
        if (Objects.equals(two, four)) {
            return this.of(one, two, three);
        }
        if (Objects.equals(three, four)) {
            return this.of(one, two, three);
        }
        return new ImmutableQuadrupletonSet<T>(one, two, three, four);
    }

    @Override
    public <T> ImmutableSet<T> of(T ... items) {
        return this.with(items);
    }

    @Override
    public <T> ImmutableSet<T> with(T ... items) {
        if (items == null || items.length == 0) {
            return this.of();
        }
        switch (items.length) {
            case 1: {
                return this.of(items[0]);
            }
            case 2: {
                return this.of(items[0], items[1]);
            }
            case 3: {
                return this.of(items[0], items[1], items[2]);
            }
            case 4: {
                return this.of(items[0], items[1], items[2], items[3]);
            }
        }
        return ImmutableUnifiedSet.newSetWith(items);
    }

    @Override
    public <T> ImmutableSet<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> ImmutableSet<T> withAll(Iterable<? extends T> items) {
        if (items instanceof ImmutableSet) {
            return (ImmutableSet)items;
        }
        if (Iterate.isEmpty(items)) {
            return this.with();
        }
        return this.with(Iterate.toArray(items));
    }
}

