/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.set;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.set.ImmutableSetMultimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.multimap.AbstractSynchronizedMultimap;

public class SynchronizedSetMultimap<K, V>
extends AbstractSynchronizedMultimap<K, V>
implements MutableSetMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    public SynchronizedSetMultimap(MutableSetMultimap<K, V> multimap) {
        super(multimap);
    }

    public SynchronizedSetMultimap(MutableSetMultimap<K, V> multimap, Object newLock) {
        super(multimap, newLock);
    }

    public static <K, V> SynchronizedSetMultimap<K, V> of(MutableSetMultimap<K, V> multimap) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedSetMultimap for null");
        }
        return new SynchronizedSetMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedSetMultimap<K, V> of(MutableSetMultimap<K, V> multimap, Object lock) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedSetMultimap for null");
        }
        return new SynchronizedSetMultimap<K, V>(multimap, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<V> replaceValues(K key, Iterable<? extends V> values) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().replaceValues((Object)key, (Iterable)values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<V> removeAll(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAll(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<K, V> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<V> get(K key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().get((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<V> getIfAbsentPutAll(K key, Iterable<? extends V> values) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().getIfAbsentPutAll((Object)key, (Iterable)values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<K, V> toMutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toMutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSetMultimap<K, V> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<V, K> flip() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysValues((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysValues((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysMultiValues((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysMultiValues((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeysValues((Function2)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeyMultiValues((Function)keyFunction, (Function)valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V2> MutableBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectValues((Function)function);
        }
    }

    @Override
    public MutableSetMultimap<K, V> asSynchronized() {
        return this;
    }

    @Override
    protected MutableSetMultimap<K, V> getDelegate() {
        return (MutableSetMultimap)super.getDelegate();
    }
}

